/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.jdbc.values.AbstractValue;
import org.neo4j.jdbc.values.Type;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

public final class ListValue
extends AbstractValue {
    private final Value[] values;

    ListValue(Value ... values) {
        this.values = Objects.requireNonNull(values, "Cannot construct ListValue from null");
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public List<Object> asObject() {
        return this.asList(Value::asObject);
    }

    @Override
    public List<Object> asList() {
        return ListValue.list(this.values, Value::asObject);
    }

    @Override
    public <T> List<T> asList(Function<Value, T> mapFunction) {
        return ListValue.list(this.values, mapFunction);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Value get(int index) {
        return index >= 0 && index < this.values.length ? this.values[index] : Values.NULL;
    }

    @Override
    public <T> Iterable<T> values(final Function<Value, T> mapFunction) {
        return () -> new Iterator<T>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < ListValue.this.values.length;
            }

            @Override
            public T next() {
                if (this.cursor >= ListValue.this.values.length) {
                    throw new NoSuchElementException();
                }
                return mapFunction.apply(ListValue.this.values[this.cursor++]);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Type type() {
        return Type.LIST;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListValue otherValues = (ListValue)o;
        return Arrays.equals(this.values, otherValues.values);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public String toString() {
        return Arrays.toString(this.values);
    }

    private static <T> List<T> list(Value[] data, Function<Value, T> mapFunction) {
        int size = data.length;
        switch (size) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(mapFunction.apply(data[0]));
            }
        }
        return Arrays.stream(data).map(mapFunction).toList();
    }
}

