/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import org.neo4j.jdbc.values.AbstractObjectValue;
import org.neo4j.jdbc.values.Type;

public final class DateTimeValue
extends AbstractObjectValue<ZonedDateTime> {
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendLiteral("DATETIME '").append(DateTimeFormatter.ISO_OFFSET_DATE_TIME).appendLiteral('\'').toFormatter();

    DateTimeValue(ZonedDateTime zonedDateTime) {
        super(zonedDateTime);
    }

    @Override
    public OffsetDateTime asOffsetDateTime() {
        return this.asZonedDateTime().toOffsetDateTime();
    }

    @Override
    public ZonedDateTime asZonedDateTime() {
        return (ZonedDateTime)this.asObject();
    }

    @Override
    public Type type() {
        return Type.DATE_TIME;
    }

    @Override
    public String toString() {
        return FORMATTER.format((TemporalAccessor)this.adapted);
    }
}

