/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.tools.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.jooq.tools.jdbc.DefaultResultSet;
import org.neo4j.jdbc.internal.shaded.jooq.tools.jdbc.JDBC41Statement;

public class DefaultStatement
extends JDBC41Statement
implements Statement {
    private final Statement delegate;
    private final Connection creator;
    private final Supplier<? extends SQLException> errorIfUnsupported;

    public DefaultStatement(Statement delegate) {
        this(delegate, null, null);
    }

    public DefaultStatement(Statement delegate, Connection creator) {
        this(delegate, creator, null);
    }

    public DefaultStatement(Statement delegate, Connection creator, Supplier<? extends SQLException> errorIfUnsupported) {
        this.delegate = delegate;
        this.creator = creator;
        this.errorIfUnsupported = errorIfUnsupported;
    }

    public Statement getDelegate() throws SQLException {
        return this.getDelegateStatement();
    }

    public Statement getDelegateStatement() throws SQLException {
        if (this.delegate != null || this.errorIfUnsupported == null) {
            return this.delegate;
        }
        throw this.errorIfUnsupported.get();
    }

    protected ResultSet wrap(ResultSet wrapped) {
        return wrapped == null ? null : new DefaultResultSet(wrapped, this);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.getDelegateStatement().execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getDelegateStatement().execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.getDelegateStatement().execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.getDelegateStatement().execute(sql, columnNames);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.getDelegateStatement().executeBatch();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.wrap(this.getDelegateStatement().executeQuery(sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.getDelegateStatement().executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getDelegateStatement().executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.getDelegateStatement().executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.getDelegateStatement().executeUpdate(sql, columnNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDelegateStatement().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDelegateStatement().isWrapperFor(iface);
    }

    @Override
    public void close() throws SQLException {
        this.getDelegateStatement().close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.getDelegateStatement().getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.getDelegateStatement().setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.getDelegateStatement().getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.getDelegateStatement().setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.getDelegateStatement().setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getDelegateStatement().getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.getDelegateStatement().setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.getDelegateStatement().cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getDelegateStatement().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getDelegateStatement().clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.getDelegateStatement().setCursorName(name);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.wrap(this.getDelegateStatement().getResultSet());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.getDelegateStatement().getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getDelegateStatement().getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.getDelegateStatement().setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.getDelegateStatement().getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.getDelegateStatement().setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getDelegateStatement().getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.getDelegateStatement().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.getDelegateStatement().getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.getDelegateStatement().addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.getDelegateStatement().clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.creator != null ? this.creator : this.getDelegateStatement().getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getDelegateStatement().getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.wrap(this.getDelegateStatement().getGeneratedKeys());
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getDelegateStatement().getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getDelegateStatement().isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.getDelegateStatement().setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.getDelegateStatement().isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.getDelegate().closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.getDelegate().isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.getDelegate().getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.getDelegate().setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.getDelegate().getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.getDelegate().executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.getDelegate().executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.getDelegate().executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.getDelegate().executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.getDelegate().executeLargeUpdate(sql, columnNames);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return this.getDelegate().enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return this.getDelegate().enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return this.getDelegate().isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return this.getDelegate().enquoteNCharLiteral(val);
    }
}

