/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class Square<T extends Number>
extends AbstractField<T>
implements QOM.Square<T> {
    final Field<T> value;

    Square(Field<T> value) {
        super(Names.N_SQUARE, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                return false;
            }
            case CUBRID: 
            case DERBY: 
            case DUCKDB: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case TRINO: 
            case YUGABYTEDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                ctx.visit(Internal.imul(this.value, this.value));
                break;
            }
            case CUBRID: 
            case DERBY: 
            case DUCKDB: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case TRINO: 
            case YUGABYTEDB: {
                if (Tools.isSimple(ctx, this.value)) {
                    ctx.visit(Internal.imul(this.value, this.value));
                    break;
                }
                ctx.visit(DSL.power(this.value, DSL.inline(2)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_SQUARE, this.getDataType(), this.value));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final QOM.Square<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue);
    }

    @Override
    public final Function1<? super Field<T>, ? extends QOM.Square<T>> $constructor() {
        return a1 -> new Square(a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Square) {
            QOM.Square o = (QOM.Square)that;
            return StringUtils.equals(this.$value(), o.$value());
        }
        return super.equals(that);
    }
}

