/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableOptions;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractTable;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.FieldsImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.RecordImplN;
import org.neo4j.jdbc.internal.shaded.jooq.impl.TableList;

final class RowsFrom
extends AbstractTable<Record>
implements QOM.RowsFrom {
    private final TableList tables;

    RowsFrom(Table<?> ... tables) {
        super(TableOptions.expression(), Names.N_ROWSFROM);
        this.tables = new TableList((List<? extends Table<?>>)Arrays.asList(tables));
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    final FieldsImpl<Record> fields0() {
        ArrayList fields = new ArrayList();
        for (Table table : this.tables) {
            for (Field<?> field : table.fields()) {
                fields.add(DSL.field(DSL.name(field.getName()), field.getDataType()));
            }
        }
        return new FieldsImpl<Record>(fields);
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(Keywords.K_ROWS_FROM).sql(" (").declareTables(true, c -> c.visit(this.tables)).sql(')');
    }

    @Override
    public final QOM.UnmodifiableList<? extends Table<?>> $tables() {
        return QOM.unmodifiable(this.tables);
    }
}

