/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.RowId;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.TableFieldImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class QualifiedRowid
extends AbstractField<RowId>
implements QOM.QualifiedRowid {
    final Table<?> table;

    QualifiedRowid(Table<?> table) {
        super(Names.N_ROWID, Tools.allNotNull(SQLDataType.ROWID));
        this.table = table;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                TableFieldImpl.accept2(ctx, this.table, DSL.systemName("_rowid_"), this.getDataType());
                break;
            }
            case POSTGRES: {
                TableFieldImpl.accept2(ctx, this.table, DSL.systemName("ctid"), this.getDataType());
                break;
            }
            default: {
                TableFieldImpl.accept2(ctx, this.table, DSL.systemName("rowid"), this.getDataType());
            }
        }
    }

    @Override
    public final Table<?> $arg1() {
        return this.table;
    }

    @Override
    public final QOM.QualifiedRowid $arg1(Table<?> newValue) {
        return this.$constructor().apply(newValue);
    }

    @Override
    public final Function1<? super Table<?>, ? extends QOM.QualifiedRowid> $constructor() {
        return a1 -> new QualifiedRowid((Table<?>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.QualifiedRowid) {
            QOM.QualifiedRowid o = (QOM.QualifiedRowid)that;
            return StringUtils.equals(this.$table(), o.$table());
        }
        return super.equals(that);
    }
}

