/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Commit;
import org.neo4j.jdbc.internal.shaded.jooq.Commits;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.ContextTransactionalRunnable;
import org.neo4j.jdbc.internal.shaded.jooq.Files;
import org.neo4j.jdbc.internal.shaded.jooq.Meta;
import org.neo4j.jdbc.internal.shaded.jooq.Migration;
import org.neo4j.jdbc.internal.shaded.jooq.MigrationListener;
import org.neo4j.jdbc.internal.shaded.jooq.Queries;
import org.neo4j.jdbc.internal.shaded.jooq.Query;
import org.neo4j.jdbc.internal.shaded.jooq.Schema;
import org.neo4j.jdbc.internal.shaded.jooq.Tag;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataMigrationException;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataMigrationVerificationException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractScope;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultMigrationContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.History;
import org.neo4j.jdbc.internal.shaded.jooq.impl.HistoryImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.HistoryRecord;
import org.neo4j.jdbc.internal.shaded.jooq.impl.HistoryResolution;
import org.neo4j.jdbc.internal.shaded.jooq.impl.HistoryStatus;
import org.neo4j.jdbc.internal.shaded.jooq.impl.MigrationListeners;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ThreadLocalTransactionProvider;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.JooqLogger;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StopWatch;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;
import org.neo4j.jdbc.internal.shaded.jooq.tools.json.JSONArray;

final class MigrationImpl
extends AbstractScope
implements Migration {
    static final JooqLogger log = JooqLogger.getLogger(Migration.class);
    final HistoryImpl history;
    final Commit to;
    Commit from;
    Queries queries;
    Commits commits;

    MigrationImpl(Configuration configuration, Commit to) {
        super(HistoryImpl.initCtx(configuration.derive(new ThreadLocalTransactionProvider(configuration.systemConnectionProvider())), configuration.settings().getMigrationDefaultSchema()));
        this.to = to;
        this.history = new HistoryImpl(this.configuration());
    }

    @Override
    public final Commit from() {
        if (this.from == null) {
            this.from = this.currentCommit();
        }
        return this.from;
    }

    @Override
    public final Commit to() {
        return this.to;
    }

    @Override
    public final Queries queries() {
        if (this.queries == null) {
            Files files = this.from().migrateTo(this.to());
            this.queries = files.from().migrateTo(files.to());
        }
        return this.queries;
    }

    private final Commits commits() {
        if (this.commits == null) {
            this.commits = this.configuration().commitProvider().provide();
        }
        return this.commits;
    }

    @Override
    public final void verify() {
        this.verify0(this.migrationContext());
    }

    private final void verify0(DefaultMigrationContext ctx) {
        HistoryRecord currentRecord = this.history.currentHistoryRecord(false);
        if (currentRecord != null) {
            switch (currentRecord.getStatus()) {
                case FAILURE: {
                    throw new DataMigrationVerificationException("Previous migration attempt from " + currentRecord.getMigratedFrom() + " to " + currentRecord.getMigratedTo() + " has failed. Please resolve before migrating.");
                }
                case STARTING: 
                case REVERTING: 
                case MIGRATING: {
                    throw new DataMigrationVerificationException("Ongoing migration from " + currentRecord.getMigratedFrom() + " to " + currentRecord.getMigratedTo() + ". Please wait until it has finished.");
                }
            }
            Commit currentCommit = this.commits().get(currentRecord.getMigratedTo());
            if (currentCommit == null) {
                throw new DataMigrationVerificationException("Version currently installed is not available from CommitProvider: " + currentRecord.getMigratedTo());
            }
        }
        this.validateCommitProvider(ctx, this.from());
        this.validateCommitProvider(ctx, this.to());
        this.revertUntracked(ctx, null, currentRecord);
    }

    private final void validateCommitProvider(DefaultMigrationContext ctx, Commit commit) {
        if (this.commits().get(commit.id()) == null) {
            throw new DataMigrationVerificationException("Commit is not available from CommitProvider: " + commit.id());
        }
        for (Schema schema : this.history.lookup(commit.meta().getSchemas())) {
            if (ctx.migratedSchemas().contains(schema)) continue;
            throw new DataMigrationVerificationException("Schema is referenced from commit, but not configured for migration: " + String.valueOf(schema));
        }
    }

    private final Queries revertUntrackedQueries(Set<Schema> includedSchemas) {
        Commit currentCommit = this.currentCommit();
        Meta currentMeta = currentCommit.meta();
        Meta existingMeta = this.dsl().meta().filterSchemas(includedSchemas::contains);
        HashSet<Schema> expectedSchemas = new HashSet<Schema>();
        expectedSchemas.addAll(this.history.lookup(this.from().meta().getSchemas()));
        expectedSchemas.addAll(this.history.lookup(this.to().meta().getSchemas()));
        expectedSchemas.retainAll(includedSchemas);
        for (Schema schema : existingMeta.getSchemas()) {
            if (!includedSchemas.contains(schema)) continue;
            existingMeta = existingMeta.apply(DSL.dropTableIfExists(schema.getQualifiedName().append(History.HISTORY.getUnqualifiedName())).cascade());
            if (!expectedSchemas.contains(schema)) {
                existingMeta = existingMeta.apply(DSL.dropSchemaIfExists(schema).cascade());
                continue;
            }
            currentMeta = currentMeta.apply(DSL.createSchemaIfNotExists(schema));
        }
        return existingMeta.migrateTo(currentMeta);
    }

    private final void revertUntracked(DefaultMigrationContext ctx, MigrationListener listener, HistoryRecord currentRecord) {
        if (ctx.revertUntrackedQueries.queries().length > 0) {
            if (!Boolean.TRUE.equals(this.dsl().settings().isMigrationRevertUntracked())) {
                throw new DataMigrationVerificationException("Non-empty difference between actual schema and migration from schema: " + String.valueOf(ctx.revertUntrackedQueries) + (currentRecord == null ? "\n\nUse Settings.migrationAutoBaseline to automatically set a baseline" : ""));
            }
            if (listener != null) {
                this.execute(ctx, listener, ctx.revertUntrackedQueries);
            }
        }
    }

    final DefaultMigrationContext migrationContext() {
        Set<Schema> schemas = this.history.schemas();
        return new DefaultMigrationContext(this.configuration(), schemas, this.from(), this.to(), this.queries(), this.revertUntrackedQueries(schemas));
    }

    @Override
    public final void execute() {
        this.run(() -> {
            DefaultMigrationContext ctx = this.migrationContext();
            MigrationListeners listener = new MigrationListeners(this.configuration);
            if (!Boolean.FALSE.equals(this.dsl().settings().isMigrationAutoVerification())) {
                this.verify0(ctx);
            }
            try {
                listener.migrationStart(ctx);
                if (this.from().equals(this.to())) {
                    log.info((Object)"jOOQ Migrations", "Version " + this.to().id() + " is already installed as the current version.");
                    return;
                }
                log.info((Object)"jOOQ Migrations", "Version " + this.from().id() + " is being migrated to " + this.to().id());
                StopWatch watch = new StopWatch();
                if (log.isDebugEnabled()) {
                    for (Query query : this.queries()) {
                        log.debug((Object)"jOOQ Migrations", this.dsl().renderInlined(query));
                    }
                }
                HistoryRecord record = this.createRecord(HistoryStatus.STARTING);
                try {
                    this.log(watch, record, HistoryStatus.REVERTING);
                    this.revertUntracked(ctx, listener, record);
                    this.log(watch, record, HistoryStatus.MIGRATING);
                    this.execute(ctx, listener, this.queries());
                    this.log(watch, record, HistoryStatus.SUCCESS);
                }
                catch (Exception e) {
                    StringWriter s = new StringWriter();
                    e.printStackTrace(new PrintWriter(s));
                    log.error((Object)"jOOQ Migrations", "Version " + this.from().id() + " migration to " + this.to().id() + " failed: " + e.getMessage());
                    this.log(watch, record, HistoryStatus.FAILURE, HistoryResolution.OPEN, s.toString());
                    throw new DataMigrationRedoLogException(record, e);
                }
            }
            finally {
                listener.migrationEnd(ctx);
            }
        });
    }

    private final HistoryRecord createRecord(HistoryStatus status) {
        HistoryRecord record = this.history.historyCtx.newRecord(History.HISTORY);
        record.setJooqVersion("3.19.24").setMigratedAt(new Timestamp(this.dsl().configuration().clock().instant().toEpochMilli())).setMigratedFrom(this.from().id()).setMigratedTo(this.to().id()).setMigratedToTags(new JSONArray(Tools.map(this.to().tags(), Tag::id)).toString()).setMigrationTime(0L).setSql(this.queries().toString()).setSqlCount(this.queries().queries().length).setStatus(status).insert();
        return record;
    }

    private final void log(StopWatch watch, HistoryRecord record, HistoryStatus status) {
        this.log(watch, record, status, null, null);
    }

    private final void log(StopWatch watch, HistoryRecord record, HistoryStatus status, HistoryResolution resolution, String message) {
        record.setMigrationTime(watch.split() / 1000000L).setStatus(status).setStatusMessage(message).setResolution(resolution).update();
    }

    private final void execute(DefaultMigrationContext ctx, MigrationListener listener, Queries q) {
        listener.queriesStart(ctx);
        for (Query query : q.queries()) {
            ctx.query(query);
            listener.queryStart(ctx);
            query.execute();
            listener.queryEnd(ctx);
            ctx.query(null);
        }
        listener.queriesEnd(ctx);
    }

    final void init() {
        this.history.init();
        DefaultMigrationContext ctx = this.migrationContext();
        if (Boolean.TRUE.equals(ctx.settings().isMigrationSchemataCreateSchemaIfNotExists())) {
            for (Schema schema : ctx.migratedSchemas()) {
                this.dsl().createSchemaIfNotExists(schema).execute();
            }
        }
    }

    final Commit currentCommit() {
        HistoryRecord currentRecord = this.history.currentHistoryRecord(true);
        if (currentRecord == null) {
            Commit result;
            Commit commit = result = Boolean.TRUE.equals(this.settings().isMigrationAutoBaseline()) ? this.to() : (Commit)this.to().root();
            if (result == null) {
                throw new DataMigrationVerificationException("CommitProvider did not provide a root version for " + this.to().id());
            }
            return result;
        }
        Commit result = this.commits().get(currentRecord.getMigratedTo());
        if (result == null) {
            throw new DataMigrationVerificationException("CommitProvider did not provide a version for " + currentRecord.getMigratedTo());
        }
        return result;
    }

    private final void run(ContextTransactionalRunnable runnable) {
        try {
            this.init();
            this.dsl().transaction(runnable);
        }
        catch (DataMigrationRedoLogException e) {
            Throwable throwable;
            HistoryRecord record = this.history.currentHistoryRecord(false);
            if (record == null || !StringUtils.equals(e.record.getId(), record.getId())) {
                e.record.changed(true);
                e.record.insert();
            }
            if ((throwable = e.getCause()) instanceof DataMigrationException) {
                DataMigrationException r = (DataMigrationException)throwable;
                throw r;
            }
            throw new DataMigrationException("Exception during migration", e);
        }
        catch (DataMigrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataMigrationException("Exception during migration", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-- Migration\n--   From: ").append(this.from().id()).append("\n").append("--   To  : ").append(this.to().id()).append("\n").append(this.queries());
        return sb.toString();
    }

    static final class DataMigrationRedoLogException
    extends DataMigrationException {
        final HistoryRecord record;

        public DataMigrationRedoLogException(HistoryRecord record, Exception cause) {
            super("Redo log", cause);
            this.record = record;
        }
    }
}

