/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.JSONValueDefaultStep;
import org.neo4j.jdbc.internal.shaded.jooq.JSONValueOnStep;
import org.neo4j.jdbc.internal.shaded.jooq.Keyword;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.JSONReturning;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class JSONValue<J>
extends AbstractField<J>
implements JSONValueOnStep<J>,
JSONValueDefaultStep<J>,
QOM.UNotYetImplemented {
    private final Field<?> json;
    private final Field<String> path;
    private final DataType<?> returning;
    private final Behaviour onError;
    private final Field<?> onErrorDefault;
    private final Behaviour onEmpty;
    private final Field<?> onEmptyDefault;
    private final Field<?> default_;

    JSONValue(DataType<J> type, Field<?> json, Field<String> path, DataType<?> returning) {
        this(type, json, path, returning, null, null, null, null, null);
    }

    private JSONValue(DataType<J> type, Field<?> json, Field<String> path, DataType<?> returning, Behaviour onError, Field<?> onErrorDefault, Behaviour onEmpty, Field<?> onEmptyDefault, Field<?> default_) {
        super(Names.N_JSON_VALUE, type);
        this.json = json;
        this.path = path;
        this.returning = returning;
        this.onError = onError;
        this.onErrorDefault = onErrorDefault;
        this.onEmpty = onEmpty;
        this.onEmptyDefault = onEmptyDefault;
        this.default_ = default_;
    }

    @Override
    public final JSONValue<J> returning(DataType<?> r) {
        return new JSONValue(this.getDataType(), this.json, this.path, r, this.onError, this.onErrorDefault, this.onEmpty, this.onEmptyDefault, null);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: 
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_JSON_EXTRACT, this.json.getDataType(), this.json, this.path));
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(DSL.function(Names.N_JSONB_PATH_QUERY_FIRST, this.json.getDataType(), Tools.castIfNeeded(this.json, SQLDataType.JSONB), DSL.field("cast({0} as jsonpath)", this.path)));
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptDefault(Context<?> ctx) {
        JSONReturning r;
        boolean format = !Tools.isSimple(ctx, this.json, this.path);
        ctx.visit(Names.N_JSON_VALUE).sql('(');
        if (format) {
            ctx.sqlIndentStart();
        }
        ctx.visit(this.json).sql(",");
        if (format) {
            ctx.formatSeparator();
        } else {
            ctx.sql(' ');
        }
        ctx.visit(this.path);
        if (this.returning != null && (r = new JSONReturning(this.returning)).rendersContent(ctx)) {
            if (format) {
                ctx.formatNewLine();
            }
            ctx.separatorRequired(true).visit(r);
        }
        if (format) {
            ctx.sqlIndentEnd();
        }
        ctx.sql(')');
    }

    static enum Behaviour {
        ERROR,
        NULL,
        DEFAULT;

        final Keyword keyword = DSL.keyword(this.name().toLowerCase());
    }
}

