/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.ConverterContext;
import org.neo4j.jdbc.internal.shaded.jooq.DSLContext;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Fields;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Result;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.Source;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRow;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ConvertedDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultJSONContentHandler;
import org.neo4j.jdbc.internal.shaded.jooq.impl.JSONParser;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ResultImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class JSONReader<R extends Record> {
    private final DSLContext ctx;
    private final AbstractRow<R> row;
    private final Class<? extends R> recordType;
    private final boolean multiset;
    private static final Set<SQLDialect> ENCODE_BINARY_AS_HEX = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> ENCODE_BINARY_AS_TEXT = SQLDialect.supportedBy(SQLDialect.MARIADB);

    JSONReader(DSLContext ctx, AbstractRow<R> row, Class<? extends R> recordType, boolean multiset) {
        this.ctx = ctx;
        this.row = row;
        this.recordType = recordType != null ? recordType : Record.class;
        this.multiset = multiset;
    }

    final Result<R> read(String string) {
        return this.read(new StringReader(string));
    }

    final Result<R> read(Reader reader) {
        return this.read(reader, false);
    }

    final Result<R> read(Reader reader, boolean multiset) {
        try {
            DefaultJSONContentHandler handler = new DefaultJSONContentHandler();
            new JSONParser(this.ctx, Source.of(reader).readString(), handler).parse();
            return JSONReader.read(this.ctx, this.row, this.recordType, multiset, handler.result());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final <R extends Record> Result<R> read(DSLContext ctx, AbstractRow<R> actualRow, Class<? extends R> recordType, boolean multiset, Object root) {
        List records;
        ArrayList header = new ArrayList();
        ResultImpl result = null;
        if (root instanceof Map) {
            Map o1 = (Map)root;
            List fields = (List)o1.get("fields");
            if (fields != null) {
                for (Object field : fields) {
                    String catalog = (String)field.get("catalog");
                    String schema = (String)field.get("schema");
                    String table = (String)field.get("table");
                    String name = (String)field.get("name");
                    String type = (String)field.get("type");
                    header.add(DSL.field(DSL.name(catalog, schema, table, name), DefaultDataType.getDataType(null, StringUtils.defaultIfBlank(type, "VARCHAR"))));
                }
            }
            records = (List)o1.get("records");
        } else {
            records = (List)root;
        }
        if (actualRow == null && !header.isEmpty()) {
            actualRow = Tools.row0(header);
        }
        if (actualRow != null) {
            result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
        }
        if (records != null) {
            for (Object o3 : records) {
                Object record;
                if (o3 instanceof Map) {
                    record = (Map)o3;
                    if (result == null) {
                        if (header.isEmpty()) {
                            for (String name : record.keySet()) {
                                header.add(DSL.field(DSL.name(name), SQLDataType.VARCHAR));
                            }
                        }
                        actualRow = Tools.row0(header);
                        result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
                    }
                    List<Object> list = multiset ? JSONReader.patchRecord(ctx, multiset, actualRow, JSONReader.sortedValues((Map<String, Object>)record)) : null;
                    result.add(Tools.newRecord(true, ctx.configuration(), recordType, actualRow).operate(arg_0 -> JSONReader.lambda$read$0(multiset, list, (Map)record, arg_0)));
                    continue;
                }
                record = (List)o3;
                if (result == null) {
                    if (header.isEmpty()) {
                        header.addAll(Arrays.asList(Tools.fields(record.size())));
                    }
                    actualRow = Tools.row0(header);
                    result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
                }
                JSONReader.patchRecord(ctx, multiset, actualRow, (List<Object>)record);
                if (record == null) {
                    result.add(null);
                    continue;
                }
                result.add(Tools.newRecord(true, ctx.configuration(), recordType, actualRow).operate(arg_0 -> JSONReader.lambda$read$1((List)record, arg_0)));
            }
        }
        return result;
    }

    private static final List<Object> sortedValues(Map<String, Object> record) {
        List<Object> result = Arrays.asList(new Object[record.size()]);
        for (Map.Entry<String, Object> e : record.entrySet()) {
            result.set(Integer.parseInt(e.getKey().substring(1)), e.getValue());
        }
        return result;
    }

    private static final List<Object> patchRecord(DSLContext ctx, boolean multiset, Fields result, List<Object> record) {
        ConverterContext cc = null;
        for (int i = 0; i < result.fields().length; ++i) {
            List<Object> l;
            Field<?> field = result.field(i);
            Object value = record.get(i);
            DataType t = field.getDataType();
            if (t.isBinary() && value instanceof String) {
                String s = (String)value;
                if (multiset) {
                    if (ENCODE_BINARY_AS_HEX.contains((Object)ctx.dialect())) {
                        if (s.startsWith("\\x")) {
                            record.set(i, Tools.convertHexToBytes(s, 1, Integer.MAX_VALUE));
                            continue;
                        }
                        record.set(i, Tools.convertHexToBytes(s));
                        continue;
                    }
                    if (ENCODE_BINARY_AS_TEXT.contains((Object)ctx.dialect())) {
                        record.set(i, s);
                        continue;
                    }
                    if (s.startsWith("base64:type15:")) {
                        record.set(i, Base64.getDecoder().decode(s.substring(14)));
                        continue;
                    }
                    record.set(i, Base64.getDecoder().decode(s));
                    continue;
                }
                record.set(i, Base64.getDecoder().decode(s));
                continue;
            }
            if (multiset && t instanceof ConvertedDataType && t.getFromType() == String.class && t.getToType() == String.class && (value == null || value instanceof String)) {
                record.set(i, t.getConverter().from((String)value, cc == null ? Tools.converterContext(ctx.configuration()) : cc));
                continue;
            }
            if (multiset && t.isMultiset()) {
                record.set(i, JSONReader.read(ctx, (AbstractRow)t.getRow(), t.getRecordType(), multiset, value));
                continue;
            }
            if (!multiset || !t.isRecord() || !(value instanceof List) && !(value instanceof Map)) continue;
            AbstractRow actualRow = (AbstractRow)t.getRow();
            Class<Record> recordType = t.getRecordType();
            if (value instanceof List) {
                l = JSONReader.patchRecord(ctx, multiset, actualRow, (List)value);
            } else if (value instanceof Map) {
                l = JSONReader.patchRecord(ctx, multiset, actualRow, new ArrayList<Object>(((Map)value).values()));
            } else {
                throw new IllegalStateException();
            }
            record.set(i, Tools.newRecord(true, ctx.configuration(), recordType, actualRow).operate(r -> {
                r.from(l);
                r.changed(false);
                return r;
            }));
        }
        return record;
    }

    private static /* synthetic */ Record lambda$read$1(List record, Record r) throws RuntimeException {
        r.from(record);
        r.changed(false);
        return r;
    }

    private static /* synthetic */ Record lambda$read$0(boolean multiset, List list, Map record, Record r) throws RuntimeException {
        if (multiset) {
            r.from(list);
        } else {
            r.fromMap(record);
        }
        r.changed(false);
        return r;
    }
}

