/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.JSON;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class JSONGetAttribute
extends AbstractField<JSON>
implements QOM.JSONGetAttribute {
    final Field<JSON> field;
    final Field<String> attribute;

    JSONGetAttribute(Field<JSON> field, Field<String> attribute) {
        super(Names.N_JSON_GET_ATTRIBUTE, Tools.allNotNull(SQLDataType.JSON, field, attribute));
        this.field = Tools.nullSafeNotNull(field, SQLDataType.JSON);
        this.attribute = Tools.nullSafeNotNull(attribute, SQLDataType.VARCHAR);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: 
            case TRINO: {
                return false;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: 
            case TRINO: {
                ctx.visit(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSON, this.field, DSL.inline("$.").concat(this.attribute)));
                break;
            }
            default: {
                ctx.sql('(').visit(this.field).sql("->").visit(this.attribute).sql(')');
            }
        }
    }

    @Override
    public final Field<JSON> $arg1() {
        return this.field;
    }

    @Override
    public final Field<String> $arg2() {
        return this.attribute;
    }

    @Override
    public final QOM.JSONGetAttribute $arg1(Field<JSON> newValue) {
        return this.$constructor().apply((Field<JSON>)newValue, (Field<String>)this.$arg2());
    }

    @Override
    public final QOM.JSONGetAttribute $arg2(Field<String> newValue) {
        return this.$constructor().apply((Field<JSON>)this.$arg1(), (Field<String>)newValue);
    }

    @Override
    public final Function2<? super Field<JSON>, ? super Field<String>, ? extends QOM.JSONGetAttribute> $constructor() {
        return (a1, a2) -> new JSONGetAttribute((Field<JSON>)a1, (Field<String>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONGetAttribute) {
            QOM.JSONGetAttribute o = (QOM.JSONGetAttribute)that;
            return StringUtils.equals(this.$field(), o.$field()) && StringUtils.equals(this.$attribute(), o.$attribute());
        }
        return super.equals(that);
    }
}

