/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.AggregateFunction;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.GroupConcatOrderByStep;
import org.neo4j.jdbc.internal.shaded.jooq.OrderField;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractAggregateFunction;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ListAgg;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SortFieldList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class GroupConcat
extends AbstractAggregateFunction<String>
implements GroupConcatOrderByStep,
QOM.UNotYetImplemented {
    final Set<SQLDialect> REQUIRE_WITHIN_GROUP = SQLDialect.supportedBy(SQLDialect.TRINO);
    private final Field<?> field;
    private final SortFieldList orderBy;
    private String separator;

    GroupConcat(Field<?> field) {
        this(field, false);
    }

    GroupConcat(Field<?> field, boolean distinct) {
        super(distinct, Names.N_GROUP_CONCAT, SQLDataType.VARCHAR, field);
        this.field = field;
        this.orderBy = new SortFieldList();
    }

    @Override
    public final void accept(Context<?> ctx) {
        ListAgg result = this.separator == null ? new ListAgg(this.distinct, this.field, DSL.inline(",")) : new ListAgg(this.distinct, this.field, DSL.inline(this.separator));
        if (!this.orderBy.isEmpty()) {
            result.withinGroupOrderBy((Collection)this.orderBy);
        } else if (this.REQUIRE_WITHIN_GROUP.contains((Object)ctx.dialect())) {
            result.withinGroupOrderBy((Collection)this.orderBy);
        }
        ctx.visit(this.fo(result));
    }

    @Override
    public final AggregateFunction<String> separator(String s) {
        this.separator = s;
        return this;
    }

    @Override
    public final GroupConcat orderBy(OrderField<?> ... fields) {
        return this.orderBy(Arrays.asList(fields));
    }

    @Override
    public final GroupConcat orderBy(Collection<? extends OrderField<?>> fields) {
        this.orderBy.addAll(Tools.sortFields(fields));
        return this;
    }
}

