/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;

final class CurrentTimestamp<T>
extends AbstractField<T>
implements QOM.CurrentTimestamp<T> {
    private static final Set<SQLDialect> NO_SUPPORT_PRECISION = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_PRECISION_BIND = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.POSTGRES);
    private final Field<Integer> precision;

    CurrentTimestamp(DataType<T> type) {
        this(type, null);
    }

    CurrentTimestamp(DataType<T> type, Field<Integer> precision) {
        super(Names.N_CURRENT_TIMESTAMP, type);
        this.precision = precision;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.precision != null && !NO_SUPPORT_PRECISION.contains((Object)ctx.dialect())) {
                    ctx.visit(Names.N_CURRENT_TIMESTAMP).sql('(').visit(this.precision).sql(')');
                    break;
                }
                ctx.visit(Names.N_CURRENT_TIMESTAMP).sql("()");
                break;
            }
            default: {
                if (this.precision != null && !NO_SUPPORT_PRECISION.contains((Object)ctx.dialect())) {
                    if (NO_SUPPORT_PRECISION_BIND.contains((Object)ctx.dialect())) {
                        ctx.visit(Keywords.K_CURRENT).sql('_').visit(Keywords.K_TIMESTAMP).sql('(').paramType(ParamType.INLINED, c -> c.visit(this.precision)).sql(')');
                        break;
                    }
                    ctx.visit(Keywords.K_CURRENT).sql('_').visit(Keywords.K_TIMESTAMP).sql('(').visit(this.precision).sql(')');
                    break;
                }
                ctx.visit(Keywords.K_CURRENT).sql('_').visit(Keywords.K_TIMESTAMP);
            }
        }
    }
}

