/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.UniqueKey;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractAggregateFunction;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultAggregateFunction;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;

final class CountTable
extends AbstractAggregateFunction<Integer>
implements QOM.CountTable {
    private final Table<?> table;

    CountTable(Table<?> table, boolean distinct) {
        super(distinct, "count", SQLDataType.INTEGER, DSL.field(DSL.name(table.getName())));
        this.table = table;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                super.accept(ctx);
                break;
            }
            default: {
                UniqueKey<?> pk = this.table.getPrimaryKey();
                if (pk != null) {
                    ctx.visit(new DefaultAggregateFunction<Integer>(this.distinct, "count", SQLDataType.INTEGER, this.table.fields(pk.getFieldsArray())));
                    break;
                }
                super.accept(ctx);
                break;
            }
        }
    }

    @Override
    public final Table<?> $table() {
        return this.table;
    }
}

