/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.TableLike;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class ArrayRemove<T>
extends AbstractField<T[]>
implements QOM.ArrayRemove<T> {
    final Field<T[]> arg1;
    final Field<T> arg2;

    ArrayRemove(Field<T[]> arg1, Field<T> arg2) {
        super(Names.N_ARRAY_REMOVE, Tools.allNotNull(Tools.dataType(SQLDataType.OTHER.array(), arg1, false), arg1, arg2));
        this.arg1 = Tools.nullSafeNotNull(arg1, SQLDataType.OTHER.array());
        this.arg2 = Tools.nullSafeNotNull(arg2, SQLDataType.OTHER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: {
                Field<T> x = DSL.field(DSL.name("x"), this.arg2.getDataType());
                Field<Long> o = DSL.field(DSL.name("o"), SQLDataType.BIGINT);
                ctx.visit(DSL.field(DSL.select(DSL.arrayAgg(x).orderBy(o)).from((TableLike<?>)DSL.unnest(this.arg1).withOrdinality().as("t", "x", "o")).where(x.ne(this.arg2))));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_ARRAY_REMOVE, this.getDataType(), this.arg1, this.arg2));
            }
        }
    }

    @Override
    public final Field<T[]> $arg1() {
        return this.arg1;
    }

    @Override
    public final Field<T> $arg2() {
        return this.arg2;
    }

    @Override
    public final QOM.ArrayRemove<T> $arg1(Field<T[]> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.ArrayRemove<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T[]>, ? super Field<T>, ? extends QOM.ArrayRemove<T>> $constructor() {
        return (a1, a2) -> new ArrayRemove((Field<T[]>)a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayRemove) {
            QOM.ArrayRemove o = (QOM.ArrayRemove)that;
            return StringUtils.equals(this.$arg1(), o.$arg1()) && StringUtils.equals(this.$arg2(), o.$arg2());
        }
        return super.equals(that);
    }
}

