/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl;

import java.io.IOException;
import java.util.Map;
import org.neo4j.jdbc.internal.shaded.jackson.core.JsonParser;
import org.neo4j.jdbc.internal.shaded.jackson.core.JsonToken;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSONObjectException;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.api.ValueReader;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl.JSONReader;

public class EnumReader
extends ValueReader {
    protected final Object[] _byIndex;
    protected final Map<String, Object> _byName;

    public EnumReader(Class<?> clazz, Object[] objectArray, Map<String, Object> map) {
        super(clazz);
        this._byIndex = objectArray;
        this._byName = map;
    }

    private String desc() {
        return this._byIndex[0].getClass().getName();
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        String string = jsonParser.nextTextValue();
        if (string != null) {
            return this._enum(string);
        }
        return this.read(jSONReader, jsonParser);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            int n = jsonParser.getIntValue();
            if (n < 0 || n >= this._byIndex.length) {
                throw new JSONObjectException("Failed to bind Enum " + this.desc() + " with index " + n + " (has " + this._byIndex.length + " values)");
            }
            return this._byIndex[n];
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._enum(jsonParser.getValueAsString().trim());
        }
        throw JSONObjectException.from(jsonParser, "Can not read Enum `" + this._valueType.getName() + "` from " + EnumReader._tokenDesc(jsonParser, jsonParser.currentToken()));
    }

    private Object _enum(String string) throws IOException {
        Object object = this._byName.get(string);
        if (object == null) {
            throw new JSONObjectException("Failed to find Enum of type " + this.desc() + " for value '" + string + "'");
        }
        return object;
    }
}

