/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl.utils;

import java.util.Arrays;
import java.util.Objects;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Strings;

@API(status=API.Status.INTERNAL, since="2020.0.0")
public final class Assertions {
    public static void hasText(String text, String message) {
        if (!Strings.hasText(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message) {
        Assertions.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (Assertions.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0 || Arrays.stream(array).allMatch(Objects::isNull);
    }

    private Assertions() {
    }
}

