/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl.renderer;

import java.util.Objects;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ReturnBody;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Subquery;
import org.neo4j.jdbc.internal.shaded.cypherdsl.With;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.EnterResult;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.VisitorWithResult;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Configuration;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.DefaultVisitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Dialect;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.GeneralizedRenderer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Renderer;

@RegisterForReflection(allDeclaredConstructors=true)
final class Neo4j523SubqueryVisitor
extends VisitorWithResult {
    private static final GeneralizedRenderer RETURN_BODY_RENDERER = Renderer.getRenderer(Configuration.newConfig().withDialect(Dialect.NEO4J_5_23).build(), GeneralizedRenderer.class);
    private final DefaultVisitor delegate;
    private With importing;

    Neo4j523SubqueryVisitor(DefaultVisitor delegate) {
        this.delegate = delegate;
    }

    @Override
    public EnterResult enterWithResult(Visitable segment) {
        if (segment instanceof Subquery) {
            Subquery subquery = (Subquery)segment;
            StringBuilder replacement = new StringBuilder("(");
            this.importing = subquery.importingWith();
            if (this.importing != null) {
                this.importing.accept(innerSegment -> {
                    if (innerSegment instanceof ReturnBody) {
                        ReturnBody returnBody = (ReturnBody)innerSegment;
                        replacement.append(RETURN_BODY_RENDERER.render(returnBody));
                    }
                });
            }
            replacement.append(") {");
            this.delegate.enter(subquery);
            this.delegate.builder.replace(this.delegate.builder.length() - 1, this.delegate.builder.length(), replacement.toString());
        } else if (segment instanceof With) {
            With possibleImporting = (With)segment;
            if (!Objects.equals(this.importing, possibleImporting)) {
                this.delegate.enter(possibleImporting);
            } else {
                return EnterResult.SKIP_CHILDREN;
            }
        }
        return EnterResult.CONTINUE;
    }

    @Override
    public void leave(Visitable segment) {
        if (segment instanceof Subquery) {
            Subquery subquery = (Subquery)segment;
            this.delegate.leave(subquery);
        } else if (segment instanceof With) {
            With possibleImporting = (With)segment;
            if (Objects.equals(this.importing, possibleImporting)) {
                this.importing = null;
            } else {
                this.delegate.leave(possibleImporting);
            }
        }
    }
}

