/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl.querydsl;

import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.Templates;

class CypherTemplates
extends Templates {
    static final String UNSUPPORTED_MARKER = "__UNSUPPORTED__";
    static final Templates DEFAULT = new CypherTemplates();

    private CypherTemplates() {
        super('\\');
        String sizeOfOneElement = "size({0})";
        this.add((Operator)Ops.AND, "{0} AND {1}", 90);
        this.add((Operator)Ops.NOT, "NOT {0}", 10);
        this.add((Operator)Ops.OR, "{0} OR {1}", 110);
        this.add((Operator)Ops.XNOR, "NOT ({0} XOR {1})", 100);
        this.add((Operator)Ops.XOR, "{0} XOR {1}", 100);
        this.add((Operator)Ops.COL_IS_EMPTY, "size({0}) = 0");
        this.add((Operator)Ops.COL_SIZE, "size({0})");
        this.add((Operator)Ops.ARRAY_SIZE, "size({0})");
        this.add((Operator)Ops.MAP_SIZE, "size(keys({0}))");
        this.add((Operator)Ops.MAP_IS_EMPTY, "size(keys({0})) = 0");
        this.add((Operator)Ops.CONTAINS_KEY, "any(v in keys({0}) where v = {1})");
        this.add((Operator)Ops.CONTAINS_VALUE, "any(v in [k IN KEYS({0}) | {0}[k]] where v = {1})");
        this.add((Operator)Ops.BETWEEN, "{0} >= {1} AND {0} <= {2}", 50);
        this.add((Operator)Ops.GOE, "{0} >= {1}", 50);
        this.add((Operator)Ops.GT, "{0} > {1}", 50);
        this.add((Operator)Ops.LOE, "{0} <= {1}", 50);
        this.add((Operator)Ops.LT, "{0} < {1}", 50);
        this.add((Operator)Ops.NEGATE, "-{0}", 20);
        this.add((Operator)Ops.ADD, "{0} + {1}", 40);
        this.add((Operator)Ops.DIV, "{0} / {1}", 30);
        this.add((Operator)Ops.MOD, "{0} % {1}", 30);
        this.add((Operator)Ops.MULT, "{0} * {1}", 30);
        this.add((Operator)Ops.SUB, "{0} - {1}", 40);
        this.add((Operator)Ops.EQ, "{0} = {1}", 60);
        this.add((Operator)Ops.EQ_IGNORE_CASE, "{0l} = {1l}", 60);
        this.add((Operator)Ops.INSTANCE_OF, UNSUPPORTED_MARKER, 50);
        this.add((Operator)Ops.NE, "{0} != {1}", 60);
        this.add((Operator)Ops.IN, "any(v in {0} where v = {1})", 50);
        this.add((Operator)Ops.NOT_IN, "none(v in {0} where v = {1})", 50);
        this.add((Operator)Ops.IS_NULL, "{0} is null", 50);
        this.add((Operator)Ops.IS_NOT_NULL, "{0} is not null", 50);
        this.add((Operator)Ops.ALIAS, "{0} as {1}", 0);
        this.add((Operator)Ops.NUMCAST, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.STRING_CAST, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.CONCAT, "{0} + {1}", 40);
        this.add((Operator)Ops.LOWER, "toLower({0})");
        this.add((Operator)Ops.SUBSTR_1ARG, "substring({0}, {1})");
        this.add((Operator)Ops.SUBSTR_2ARGS, "substring({0}, {1}, {2})");
        this.add((Operator)Ops.TRIM, "trim({0})");
        this.add((Operator)Ops.UPPER, "toUpper({0})");
        this.add((Operator)Ops.MATCHES, "{0} =~ {1}");
        this.add((Operator)Ops.MATCHES_IC, "{0} =~ ('(?i)' + {1})");
        this.add((Operator)Ops.STARTS_WITH, "{0} STARTS WITH {1}");
        this.add((Operator)Ops.STARTS_WITH_IC, "{0l} STARTS WITH {1l}");
        this.add((Operator)Ops.ENDS_WITH, "{0} ENDS WITH {1}");
        this.add((Operator)Ops.ENDS_WITH_IC, "{0l} ENDS WITH {1l}");
        this.add((Operator)Ops.STRING_CONTAINS, "{0} CONTAINS {1}");
        this.add((Operator)Ops.STRING_CONTAINS_IC, "{0l} CONTAINS {1l}");
        this.add((Operator)Ops.CHAR_AT, "substring({0}, {1}, 1)");
        this.add((Operator)Ops.STRING_LENGTH, "size({0})");
        this.add((Operator)Ops.INDEX_OF, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.INDEX_OF_2ARGS, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.STRING_IS_EMPTY, "size({0}) = 0 ");
        this.add((Operator)Ops.LIKE, "{0} =~ '.*' + {1} + '.*'", 50);
        this.add((Operator)Ops.LIKE_IC, "{0} =~ '(?i).*' + {1} + '.*'", 50);
        this.add((Operator)Ops.LIKE_ESCAPE, UNSUPPORTED_MARKER, 50);
        this.add((Operator)Ops.LIKE_ESCAPE_IC, UNSUPPORTED_MARKER, 50);
        this.add((Operator)Ops.StringOps.LEFT, "left({0}, {1})");
        this.add((Operator)Ops.StringOps.RIGHT, "right({0}, {1})");
        this.add((Operator)Ops.StringOps.LTRIM, "ltrim({0})");
        this.add((Operator)Ops.StringOps.RTRIM, "rtrim({0})");
        this.add((Operator)Ops.StringOps.LOCATE, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.StringOps.LOCATE2, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.StringOps.LPAD, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.StringOps.RPAD, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.StringOps.LPAD2, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.StringOps.RPAD2, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.DateTimeOps.SYSDATE, "datetime()");
        this.add((Operator)Ops.DateTimeOps.CURRENT_DATE, "date()");
        this.add((Operator)Ops.DateTimeOps.CURRENT_TIME, "time()");
        this.add((Operator)Ops.DateTimeOps.CURRENT_TIMESTAMP, "datetime().epochmillis");
        this.add((Operator)Ops.DateTimeOps.DATE, "date({0})");
        this.add((Operator)Ops.DateTimeOps.MILLISECOND, "{0}.millisecond");
        this.add((Operator)Ops.DateTimeOps.SECOND, "{0}.second");
        this.add((Operator)Ops.DateTimeOps.MINUTE, "{0}.minute");
        this.add((Operator)Ops.DateTimeOps.HOUR, "{0}.hour");
        this.add((Operator)Ops.DateTimeOps.WEEK, "{0}.week");
        this.add((Operator)Ops.DateTimeOps.MONTH, "{0}.month");
        this.add((Operator)Ops.DateTimeOps.YEAR, "{0}.year");
        this.add((Operator)Ops.DateTimeOps.YEAR_MONTH, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.DateTimeOps.YEAR_WEEK, "{0}.weekYear");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_WEEK, "{0}.dayOfWeek");
        this.add((Operator)Ops.DateTimeOps.DAY_OF_MONTH, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.DateTimeOps.DAY_OF_YEAR, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.DateTimeOps.ADD_YEARS, "{0} + duration({years: {1}})");
        this.add((Operator)Ops.DateTimeOps.ADD_MONTHS, "{0} + duration({months: {1}})");
        this.add((Operator)Ops.DateTimeOps.ADD_WEEKS, "{0} + duration({weeks: {1}})");
        this.add((Operator)Ops.DateTimeOps.ADD_DAYS, "{0} + duration({days: {1}})");
        this.add((Operator)Ops.DateTimeOps.ADD_HOURS, "{0} + duration({hours: {1}})");
        this.add((Operator)Ops.DateTimeOps.ADD_MINUTES, "{0} + duration({minutes: {1}})");
        this.add((Operator)Ops.DateTimeOps.ADD_SECONDS, "{0} + duration({seconds: {1}})");
        this.add((Operator)Ops.DateTimeOps.DIFF_YEARS, "duration.between({0}, {1}).years");
        this.add((Operator)Ops.DateTimeOps.DIFF_MONTHS, "duration.between({0}, {1}).months");
        this.add((Operator)Ops.DateTimeOps.DIFF_WEEKS, "duration.between({0}, {1}).weeks");
        this.add((Operator)Ops.DateTimeOps.DIFF_DAYS, "duration.between({0}, {1}).days");
        this.add((Operator)Ops.DateTimeOps.DIFF_HOURS, "duration.between({0}, {1}).hours");
        this.add((Operator)Ops.DateTimeOps.DIFF_MINUTES, "duration.between({0}, {1}).minutes");
        this.add((Operator)Ops.DateTimeOps.DIFF_SECONDS, "duration.between({0}, {1}).seconds");
        this.add((Operator)Ops.DateTimeOps.TRUNC_YEAR, "date.truncate('year', {0})");
        this.add((Operator)Ops.DateTimeOps.TRUNC_MONTH, "date.truncate('month', {0})");
        this.add((Operator)Ops.DateTimeOps.TRUNC_WEEK, "date.truncate('week', {0})");
        this.add((Operator)Ops.DateTimeOps.TRUNC_DAY, "date.truncate('day', {0})");
        this.add((Operator)Ops.DateTimeOps.TRUNC_HOUR, "datetime.truncate('hour', {0})");
        this.add((Operator)Ops.DateTimeOps.TRUNC_MINUTE, "datetime.truncate('minute', {0})");
        this.add((Operator)Ops.DateTimeOps.TRUNC_SECOND, "datetime.truncate('second', {0})");
        this.add((Operator)Ops.MathOps.ABS, "abs({0})");
        this.add((Operator)Ops.MathOps.ACOS, "acos({0})");
        this.add((Operator)Ops.MathOps.ASIN, "asin({0})");
        this.add((Operator)Ops.MathOps.ATAN, "atan({0})");
        this.add((Operator)Ops.MathOps.CEIL, "ceil({0})");
        this.add((Operator)Ops.MathOps.COS, "cos({0})");
        this.add((Operator)Ops.MathOps.COSH, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.COT, "cot({0})");
        this.add((Operator)Ops.MathOps.COTH, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.DEG, "degrees({0})");
        this.add((Operator)Ops.MathOps.TAN, "tan({0})");
        this.add((Operator)Ops.MathOps.TANH, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.SQRT, "sqrt({0})");
        this.add((Operator)Ops.MathOps.SIGN, "sign({0})");
        this.add((Operator)Ops.MathOps.SIN, "sin({0})");
        this.add((Operator)Ops.MathOps.SINH, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.ROUND, "round({0})");
        this.add((Operator)Ops.MathOps.ROUND2, "round({0}, {1})");
        this.add((Operator)Ops.MathOps.RAD, "radians({0})");
        this.add((Operator)Ops.MathOps.RANDOM, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.RANDOM2, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.POWER, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.MIN, "CASE WHEN {0} < {1} THEN {0} ELSE {1} END");
        this.add((Operator)Ops.MathOps.MAX, "CASE WHEN {0} > {1} THEN {0} ELSE {1} END");
        this.add((Operator)Ops.MathOps.LOG, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.LN, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.MathOps.FLOOR, "floor({0})");
        this.add((Operator)Ops.MathOps.EXP, "exp({0})");
        this.add((Operator)PathType.PROPERTY, "{0}.{1s}");
        this.add((Operator)PathType.VARIABLE, "{0s}");
        this.add((Operator)PathType.DELEGATE, "{0}");
        this.add((Operator)Ops.ORDINAL, UNSUPPORTED_MARKER);
        for (PathType type : new PathType[]{PathType.LISTVALUE, PathType.MAPVALUE, PathType.ARRAYVALUE}) {
            this.add((Operator)type, "{0}[{1}]");
        }
        for (PathType type : new PathType[]{PathType.LISTVALUE_CONSTANT, PathType.MAPVALUE_CONSTANT, PathType.ARRAYVALUE_CONSTANT}) {
            this.add((Operator)type, "{0}[{1s}]");
        }
        this.add((Operator)Ops.CASE, "CASE {0} END", 70);
        this.add((Operator)Ops.CASE_WHEN, "WHEN {0} THEN {1} {2}", 70);
        this.add((Operator)Ops.CASE_ELSE, "ELSE {0}", 70);
        this.add((Operator)Ops.CASE_EQ, "CASE {0} {1} END", 70);
        this.add((Operator)Ops.CASE_EQ_WHEN, "WHEN {1} THEN {2} {3}", 70);
        this.add((Operator)Ops.CASE_EQ_ELSE, "ELSE {0}", 70);
        this.add((Operator)Ops.COALESCE, "coalesce({0})");
        this.add((Operator)Ops.NULLIF, UNSUPPORTED_MARKER);
        this.add((Operator)Ops.EXISTS, "exists({0})", 0);
        this.add((Operator)Ops.AggOps.BOOLEAN_ALL, "all({0})");
        this.add((Operator)Ops.AggOps.BOOLEAN_ANY, "any({0})");
        this.add((Operator)Ops.AggOps.AVG_AGG, "avg({0})");
        this.add((Operator)Ops.AggOps.MAX_AGG, "max({0})");
        this.add((Operator)Ops.AggOps.MIN_AGG, "min({0})");
        this.add((Operator)Ops.AggOps.SUM_AGG, "sum({0})");
        this.add((Operator)Ops.AggOps.COUNT_AGG, "count({0})");
        this.add((Operator)Ops.AggOps.COUNT_DISTINCT_AGG, "count(distinct {0})");
        this.add((Operator)Ops.AggOps.COUNT_DISTINCT_ALL_AGG, "count(distinct *)");
        this.add((Operator)Ops.AggOps.COUNT_ALL_AGG, "count(*)");
        this.add((Operator)Ops.QuantOps.AVG_IN_COL, "avg({0})");
        this.add((Operator)Ops.QuantOps.MAX_IN_COL, "max({0})");
        this.add((Operator)Ops.QuantOps.MIN_IN_COL, "min({0})");
        this.add((Operator)Ops.QuantOps.ANY, "any {0}");
        this.add((Operator)Ops.QuantOps.ALL, "all {0}");
    }
}

