/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Clause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Limit;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Order;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Return;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ReturnBody;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Skip;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.EnterResult;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.Distinct;

@API(status=API.Status.STABLE, since="1.0")
public final class With
implements Visitable,
Clause {
    private final Distinct distinct;
    private final ReturnBody body;
    private final Where where;

    With(Return returnClause, Where where) {
        this.distinct = returnClause.getDistinct();
        this.body = returnClause.getBody();
        this.where = where;
    }

    With(boolean distinct, ExpressionList returnItems, Order order, Skip skip, Limit limit, Where where) {
        this.distinct = distinct ? Distinct.INSTANCE : null;
        this.body = new ReturnBody(returnItems, order, skip, limit);
        this.where = where;
    }

    @Override
    public void accept(Visitor visitor) {
        if (visitor.enterWithResult(this) == EnterResult.CONTINUE) {
            Visitable.visitIfNotNull(this.distinct, visitor);
            this.body.accept(visitor);
            Visitable.visitIfNotNull(this.where, visitor);
        }
        visitor.leave(this);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }

    @API(status=API.Status.INTERNAL)
    public List<Expression> getItems() {
        return this.body.getReturnItems();
    }
}

