/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Clause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ClausesBasedStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.DecoratedQuery;
import org.neo4j.jdbc.internal.shaded.cypherdsl.DefaultStatementBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ResultStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementCatalog;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementContext;
import org.neo4j.jdbc.internal.shaded.cypherdsl.UnionQueryImpl;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.LoadCSV;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.ProcedureName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.UsingPeriodicCommit;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public interface Statement
extends Visitable {
    @NotNull
    @Contract(pure=true)
    public static StatementBuilder builder() {
        return new DefaultStatementBuilder(new Visitable[0]);
    }

    @NotNull
    public static Statement of(@NotNull List<Clause> clauses) {
        Assertions.notNull(clauses, "Clauses must not be null.");
        return new ClausesBasedStatement(clauses, null);
    }

    @API(status=API.Status.STABLE, since="2021.3.0")
    @NotNull
    public static Statement usingPeriodic(Integer batchSize, @NotNull List<Clause> clauses) {
        Assertions.notNull(clauses, "Clauses must not be null.");
        Assertions.isTrue(!clauses.isEmpty(), "Clauses must not be empty.");
        Assertions.isInstanceOf(LoadCSV.class, clauses.get(0), "First clause must be a LOAD CSV clause.");
        return new ClausesBasedStatement(clauses, new UsingPeriodicCommit(batchSize));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String ... namespaceAndProcedure) {
        return new DefaultStatementBuilder.StandaloneCallBuilder(ProcedureName.from(namespaceAndProcedure));
    }

    @NotNull
    @Contract(pure=true)
    public StatementCatalog getCatalog();

    @NotNull
    @Contract(pure=true)
    public String getCypher();

    @API(status=API.Status.INTERNAL, since="2021.0.0")
    @NotNull
    @Contract(pure=true)
    public StatementContext getContext();

    @Contract(pure=true)
    public boolean isRenderConstantsAsParameters();

    public void setRenderConstantsAsParameters(boolean var1);

    default public boolean doesReturnOrYield() {
        return this instanceof ResultStatement || this instanceof UnionQueryImpl;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UseStatement
    extends Statement {
        @NotNull
        @Contract(pure=true)
        default public Statement explain() {
            return DecoratedQuery.explain(this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UnionQuery
    extends RegularQuery {
    }

    public static interface SingleQuery
    extends RegularQuery {
    }

    public static interface RegularQuery
    extends Statement {
    }
}

