/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.LinkedList;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesPatternLengthAccessors;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.QuantifiedPathPattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipPattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.RelationshipPatternCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class RelationshipChain
implements RelationshipPattern,
ExposesPatternLengthAccessors<RelationshipChain> {
    private final LinkedList<Relationship> relationships;

    static RelationshipChain create(Relationship firstElement) {
        return new RelationshipChain(firstElement);
    }

    private RelationshipChain(Relationship firstElement) {
        this.relationships = new LinkedList();
        this.relationships.add(firstElement);
    }

    private RelationshipChain(List<Relationship> firstElements, Relationship lastElement) {
        this.relationships = new LinkedList<Relationship>(firstElements);
        this.relationships.add(lastElement);
    }

    private RelationshipChain(List<Relationship> elements) {
        this.relationships = new LinkedList<Relationship>(elements);
    }

    RelationshipChain add(Relationship element) {
        Assertions.notNull(element, "Elements of a relationship chain must not be null.");
        return new RelationshipChain(this.relationships, element);
    }

    RelationshipChain replaceLast(Relationship element) {
        Assertions.notNull(element, "Elements of a relationship chain must not be null.");
        RelationshipChain newChain = new RelationshipChain(this.relationships);
        newChain.relationships.removeLast();
        newChain.relationships.add(element);
        return newChain;
    }

    @Override
    @NotNull
    public RelationshipChain relationshipTo(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipTo(other, types));
    }

    @Override
    @NotNull
    public RelationshipChain relationshipFrom(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipFrom(other, types));
    }

    @Override
    @NotNull
    public RelationshipChain relationshipBetween(Node other, String ... types) {
        return this.add((Relationship)this.relationships.getLast().getRight().relationshipBetween(other, types));
    }

    @NotNull
    public RelationshipChain named(String newSymbolicName) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast(lastElement.named(newSymbolicName));
    }

    @NotNull
    public RelationshipChain named(SymbolicName newSymbolicName) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast(lastElement.named(newSymbolicName));
    }

    @Override
    @NotNull
    public RelationshipChain where(@Nullable Expression predicate) {
        if (predicate == null) {
            return this;
        }
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.where(predicate));
    }

    @Override
    @NotNull
    public RelationshipPattern quantifyRelationship(@Nullable QuantifiedPathPattern.Quantifier quantifier) {
        if (quantifier == null) {
            return this;
        }
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.quantifyRelationship(quantifier));
    }

    @Override
    @NotNull
    public QuantifiedPathPattern quantify(@Nullable QuantifiedPathPattern.Quantifier newQuantifier) {
        return QuantifiedPathPattern.of(this, newQuantifier);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public RelationshipChain unbounded() {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.unbounded());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public RelationshipChain min(Integer minimum) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.min(minimum));
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public RelationshipChain max(Integer maximum) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.max(maximum));
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public RelationshipChain length(Integer minimum, Integer maximum) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.length(minimum, maximum));
    }

    @NotNull
    @Contract(pure=true)
    public RelationshipChain properties(MapExpression newProperties) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.withProperties(newProperties));
    }

    @NotNull
    @Contract(pure=true)
    public RelationshipChain properties(Object ... keysAndValues) {
        Relationship lastElement = this.relationships.getLast();
        return this.replaceLast((Relationship)lastElement.withProperties(keysAndValues));
    }

    @Override
    @NotNull
    public Condition asCondition() {
        return RelationshipPatternCondition.of(this);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Node lastNode = null;
        for (Relationship relationship : this.relationships) {
            visitor.enter(relationship);
            relationship.getLeft().accept(visitor);
            relationship.getDetails().accept(visitor);
            Visitable.visitIfNotNull(relationship.getQuantifier(), visitor);
            visitor.leave(relationship);
            lastNode = relationship.getRight();
        }
        Visitable.visitIfNotNull(lastNode, visitor);
        visitor.leave(this);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

