/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.BuiltInFunctions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.FunctionInvocation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.annotations.CheckReturnValue;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.TypedSubtree;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="2020.1.5")
public final class Reduction
extends TypedSubtree<Visitable> {
    @NotNull
    @Contract(pure=true)
    static OngoingDefinitionWithVariable of(SymbolicName variable) {
        Assertions.notNull(variable, "A variable is required");
        return new Builder(variable);
    }

    private Reduction(Visitable ... children) {
        super(children);
    }

    private static class Builder
    implements OngoingDefinitionWithVariable,
    OngoingDefinitionWithList,
    OngoingDefinitionWithInitial,
    OngoingDefinitionWithReducer {
        private Expression accumulatorExpression;
        private final SymbolicName variable;
        private Expression listExpression;
        private Expression mapExpression;

        private Builder(SymbolicName variable) {
            this.variable = variable;
        }

        @Override
        public OngoingDefinitionWithList in(Expression list) {
            this.listExpression = list;
            return this;
        }

        @Override
        public OngoingDefinitionWithReducer map(Expression mapper) {
            this.mapExpression = mapper;
            return this;
        }

        @Override
        public OngoingDefinitionWithInitial accumulateOn(Expression accumulator) {
            this.accumulatorExpression = accumulator;
            return this;
        }

        @Override
        public FunctionInvocation withInitialValueOf(Expression initialValue) {
            Condition accumulatorAssignment = this.accumulatorExpression.isEqualTo(initialValue);
            ReductionPipeline reductionPipeline = new ReductionPipeline(this.variable, this.listExpression, this.mapExpression);
            Reduction reduction = new Reduction(new Visitable[]{accumulatorAssignment, reductionPipeline});
            return FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Lists.REDUCE, reduction);
        }
    }

    private static final class ReductionPipeline
    implements Visitable {
        private final SymbolicName variable;
        private final Expression list;
        private final Expression expression;

        ReductionPipeline(SymbolicName variable, Expression list, Expression expression) {
            this.variable = variable;
            this.list = list;
            this.expression = expression;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.variable.accept(visitor);
            Operator.IN.accept(visitor);
            this.list.accept(visitor);
            Operator.PIPE.accept(visitor);
            this.expression.accept(visitor);
            visitor.leave(this);
        }

        @Override
        public String toString() {
            return RendererBridge.render(this);
        }
    }

    public static interface OngoingDefinitionWithInitial {
        @NotNull
        @Contract(pure=true)
        public FunctionInvocation withInitialValueOf(Expression var1);
    }

    public static interface OngoingDefinitionWithReducer {
        @NotNull
        @CheckReturnValue
        public OngoingDefinitionWithInitial accumulateOn(Expression var1);
    }

    public static interface OngoingDefinitionWithList {
        @NotNull
        @CheckReturnValue
        public OngoingDefinitionWithReducer map(Expression var1);
    }

    public static interface OngoingDefinitionWithVariable {
        @NotNull
        @CheckReturnValue
        public OngoingDefinitionWithList in(Expression var1);
    }
}

