/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.Optional;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Cypher;
import org.neo4j.jdbc.internal.shaded.cypherdsl.FunctionInvocation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Named;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternSelector;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.1")
public final class NamedPath
implements PatternElement,
Named {
    private final SymbolicName name;
    private final PatternSelector optionalPatternSelector;
    private final Visitable optionalPattern;

    static OngoingDefinitionWithName named(String name) {
        return NamedPath.named(SymbolicName.of(name));
    }

    static OngoingDefinitionWithName named(SymbolicName name) {
        Assertions.notNull(name, "A name is required");
        return new Builder(name);
    }

    static OngoingShortestPathDefinitionWithName named(String name, FunctionInvocation.FunctionDefinition algorithm) {
        return new ShortestPathBuilder(SymbolicName.of(name), algorithm);
    }

    static OngoingShortestPathDefinitionWithName named(SymbolicName name, FunctionInvocation.FunctionDefinition algorithm) {
        Assertions.notNull(name, "A name is required");
        return new ShortestPathBuilder(name, algorithm);
    }

    static OngoingShortestDefinition shortest(int k) {
        return new ShortestBuilder(PatternSelector.shortestK(k));
    }

    static OngoingShortestDefinition allShortest() {
        return new ShortestBuilder(PatternSelector.allShortest());
    }

    static OngoingShortestDefinition shortestKGroups(int k) {
        return new ShortestBuilder(PatternSelector.shortestKGroups(k));
    }

    static OngoingShortestDefinition any() {
        return new ShortestBuilder(PatternSelector.any());
    }

    @API(status=API.Status.INTERNAL, since="2024.7.0")
    public static NamedPath select(PatternSelector patternSelector, PatternElement patternElement) {
        if (patternElement instanceof NamedPath) {
            NamedPath namedPath = (NamedPath)patternElement;
            Visitable visitable = namedPath.optionalPattern;
            if (visitable instanceof PatternElement) {
                PatternElement target = (PatternElement)visitable;
                return new NamedPath(namedPath.name, patternSelector, target);
            }
        }
        return new NamedPath(SymbolicName.unresolved(), patternSelector, patternElement);
    }

    private NamedPath(SymbolicName name) {
        this.name = name;
        this.optionalPatternSelector = null;
        this.optionalPattern = null;
    }

    private NamedPath(SymbolicName name, PatternSelector optionalPatternSelector, PatternElement optionalPattern) {
        this.name = name;
        this.optionalPatternSelector = optionalPatternSelector;
        this.optionalPattern = optionalPattern;
    }

    private NamedPath(SymbolicName name, FunctionInvocation algorithm) {
        this.name = name;
        this.optionalPatternSelector = null;
        this.optionalPattern = algorithm;
    }

    @Override
    @NotNull
    public Optional<SymbolicName> getSymbolicName() {
        return Optional.of(this.name);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.name.accept(visitor);
        if (this.optionalPattern != null) {
            Operator.ASSIGMENT.accept(visitor);
            Visitable.visitIfNotNull(this.optionalPatternSelector, visitor);
            this.optionalPattern.accept(visitor);
        }
        visitor.leave(this);
    }

    public static interface OngoingDefinitionWithName
    extends OngoingNamedDefinition {
        @NotNull
        @Contract(pure=true)
        public NamedPath get();
    }

    private record Builder(SymbolicName name) implements OngoingDefinitionWithName
    {
        @Override
        @NotNull
        public NamedPath definedBy(PatternElement pattern) {
            if (pattern instanceof NamedPath) {
                NamedPath namedPath = (NamedPath)pattern;
                return namedPath;
            }
            return new NamedPath(this.name, null, pattern);
        }

        @Override
        @NotNull
        public NamedPath get() {
            return new NamedPath(this.name);
        }
    }

    private record ShortestPathBuilder(SymbolicName name, FunctionInvocation.FunctionDefinition algorithm) implements OngoingShortestPathDefinitionWithName
    {
        @Override
        public NamedPath definedBy(Relationship relationship) {
            return new NamedPath(this.name, FunctionInvocation.create(this.algorithm, relationship));
        }
    }

    private static class ShortestBuilder
    implements OngoingShortestDefinition,
    OngoingNamedDefinition {
        private final PatternSelector shortest;
        private SymbolicName name;

        private ShortestBuilder(PatternSelector shortest) {
            this.shortest = shortest;
        }

        @Override
        public OngoingNamedDefinition named(SymbolicName newName) {
            this.name = newName;
            return this;
        }

        @Override
        @NotNull
        public NamedPath definedBy(PatternElement pattern) {
            return new NamedPath(this.name, this.shortest, pattern);
        }
    }

    public static interface OngoingShortestDefinition {
        default public OngoingNamedDefinition named(String name) {
            return this.named(Cypher.name(name));
        }

        public OngoingNamedDefinition named(SymbolicName var1);
    }

    public static interface OngoingShortestPathDefinitionWithName {
        public NamedPath definedBy(Relationship var1);
    }

    public static interface OngoingNamedDefinition {
        @NotNull
        @Contract(pure=true)
        public NamedPath definedBy(PatternElement var1);
    }
}

