/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AbstractClause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Hint;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Pattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ReadingClause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.STABLE, since="1.0")
public final class Match
extends AbstractClause
implements ReadingClause {
    private final boolean optional;
    final Pattern pattern;
    private final List<Hint> hints;
    private final Where optionalWhere;

    Match(boolean optional, Pattern pattern, @Nullable Where optionalWhere, @Nullable List<Hint> optionalHints) {
        this.optional = optional;
        this.pattern = pattern;
        this.optionalWhere = optionalWhere;
        this.hints = optionalHints == null ? Collections.emptyList() : new ArrayList<Hint>(optionalHints);
    }

    @API(status=API.Status.INTERNAL)
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.pattern.accept(visitor);
        this.hints.forEach(value -> value.accept(visitor));
        Visitable.visitIfNotNull(this.optionalWhere, visitor);
        visitor.leave(this);
    }
}

