/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.Optional;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Cypher;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Literal;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LiteralBase;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.ProvidesAffixes;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="2020.1.0")
public final class ListOperator
implements Expression,
Visitable {
    static final Literal<String> DOTS = new LiteralBase<String>(".."){

        @Override
        @NotNull
        public String asString() {
            return (String)this.content;
        }
    };
    private final Expression targetExpression;
    private final Details details;

    static ListOperator subList(Expression targetExpression, Expression start, Expression end) {
        Assertions.notNull(targetExpression, Cypher.MESSAGES.getString("assertions.range-target-required"));
        Assertions.notNull(start, Cypher.MESSAGES.getString("assertions.range-start-required"));
        Assertions.notNull(end, Cypher.MESSAGES.getString("assertions.range-end-required"));
        return new ListOperator(targetExpression, start, DOTS, end);
    }

    static ListOperator subListFrom(Expression targetExpression, Expression start) {
        Assertions.notNull(targetExpression, Cypher.MESSAGES.getString("assertions.range-target-required"));
        Assertions.notNull(start, Cypher.MESSAGES.getString("assertions.range-start-required"));
        return new ListOperator(targetExpression, start, DOTS, null);
    }

    static ListOperator subListUntil(Expression targetExpression, Expression end) {
        Assertions.notNull(targetExpression, Cypher.MESSAGES.getString("assertions.range-target-required"));
        Assertions.notNull(end, Cypher.MESSAGES.getString("assertions.range-end-required"));
        return new ListOperator(targetExpression, null, DOTS, end);
    }

    static ListOperator valueAt(Expression targetExpression, Expression index) {
        Assertions.notNull(targetExpression, Cypher.MESSAGES.getString("assertions.range-target-required"));
        Assertions.notNull(index, Cypher.MESSAGES.getString("assertions.range-index-required"));
        return new ListOperator(targetExpression, index, null, null);
    }

    private ListOperator(Expression targetExpression, Expression optionalStart, Literal<String> dots, Expression optionalEnd) {
        this.targetExpression = targetExpression;
        this.details = new Details(optionalStart, dots, optionalEnd);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.targetExpression.accept(visitor);
        this.details.accept(visitor);
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    static final class Details
    implements Visitable,
    ProvidesAffixes {
        private final Expression optionalStart;
        private final Literal<String> dots;
        private final Expression optionalEnd;

        Details(Expression optionalStart, Literal<String> dots, Expression optionalEnd) {
            this.optionalStart = optionalStart;
            this.dots = dots;
            this.optionalEnd = optionalEnd;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            Visitable.visitIfNotNull(this.optionalStart, visitor);
            Visitable.visitIfNotNull(this.dots, visitor);
            Visitable.visitIfNotNull(this.optionalEnd, visitor);
            visitor.leave(this);
        }

        @Override
        public Optional<String> getPrefix() {
            return Optional.of("[");
        }

        @Override
        public Optional<String> getSuffix() {
            return Optional.of("]");
        }

        @Override
        public String toString() {
            return RendererBridge.render(this);
        }
    }
}

