/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class KeyValueMapEntry
implements Expression {
    private final String key;
    private final Expression value;

    @API(status=API.Status.STABLE, since="2021.2.3")
    @NotNull
    public static KeyValueMapEntry create(@NotNull String key, @NotNull Expression value) {
        Assertions.notNull(key, "Key is required.");
        Assertions.notNull(value, "Value is required.");
        return new KeyValueMapEntry(key, value);
    }

    private KeyValueMapEntry(String key, Expression value) {
        this.key = key;
        this.value = value;
    }

    @API(status=API.Status.INTERNAL)
    public String getKey() {
        return this.key;
    }

    @API(status=API.Status.INTERNAL)
    public Expression getValue() {
        return this.value;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.value.accept(visitor);
        visitor.leave(this);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

