/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.lang.reflect.Array;
import java.net.URI;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Asterisk;
import org.neo4j.jdbc.internal.shaded.cypherdsl.BooleanLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.BuiltInFunctions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Case;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ClausesBasedStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Conditions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.CountExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.DecoratedQuery;
import org.neo4j.jdbc.internal.shaded.cypherdsl.DurationLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesLoadCSV;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesSubqueryCall;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expressions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ForeignAdapter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ForeignAdapterFactory;
import org.neo4j.jdbc.internal.shaded.cypherdsl.FunctionInvocation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Functions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.InternalNodeImpl;
import org.neo4j.jdbc.internal.shaded.cypherdsl.InternalPropertyImpl;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LabelExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListComprehension;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListOperator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Literal;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LoadCSVStatementBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapProjection;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Named;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NamedPath;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Neo4jVersion;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NullLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NumberLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.OngoingListBasedPredicateFunction;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operations;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Parameter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternComprehension;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PeriodLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Predicates;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RawLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Reduction;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipPattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SortItem;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StringLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SubqueryExpressionBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.TemporalLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.UnionQueryImpl;
import org.neo4j.jdbc.internal.shaded.cypherdsl.UseClauseImpl;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class Cypher {
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle("org.neo4j.jdbc.internal.shaded.cypherdsl.messages");
    private static volatile ForeignAdapterFactory foreignAdapterFactory;

    @NotNull
    @Contract(pure=true)
    public static Node node(String primaryLabel, String ... additionalLabels) {
        return new InternalNodeImpl(primaryLabel, additionalLabels);
    }

    @NotNull
    @Contract(pure=true)
    public static Node node(String primaryLabel, List<String> additionalLabels) {
        return new InternalNodeImpl(primaryLabel, additionalLabels.toArray(new String[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Node node(String primaryLabel, MapExpression properties, String ... additionalLabels) {
        return new InternalNodeImpl(null, primaryLabel, properties, additionalLabels);
    }

    @NotNull
    @Contract(pure=true)
    public static Node node(String primaryLabel, MapExpression properties, Collection<String> additionalLabels) {
        return Cypher.node(primaryLabel, properties, additionalLabels.toArray(new String[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Node anyNode() {
        return new InternalNodeImpl();
    }

    @NotNull
    @Contract(pure=true)
    public static Node node(LabelExpression labelExpression) {
        return new InternalNodeImpl(Objects.requireNonNull(labelExpression), null);
    }

    @NotNull
    @Contract(pure=true)
    public static Asterisk asterisk() {
        return Asterisk.INSTANCE;
    }

    @NotNull
    @Contract(pure=true)
    public static Node anyNode(String symbolicName) {
        return new InternalNodeImpl().named(symbolicName);
    }

    @NotNull
    @Contract(pure=true)
    public static Node anyNode(SymbolicName symbolicName) {
        return new InternalNodeImpl().named(symbolicName);
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(String containerName, String ... names) {
        return Cypher.property((Expression)Cypher.name(containerName), names);
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(String containerName, Collection<String> names) {
        return Cypher.property((Expression)Cypher.name(containerName), names.toArray(new String[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(Expression expression, String ... names) {
        return InternalPropertyImpl.create(expression, names);
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(Expression expression, Collection<String> names) {
        return Cypher.property(expression, names.toArray(new String[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(String containerName, Expression lookup) {
        return Cypher.property((Expression)Cypher.name(containerName), lookup);
    }

    @NotNull
    @Contract(pure=true)
    public static Property property(Expression expression, Expression lookup) {
        return InternalPropertyImpl.create(expression, lookup);
    }

    @NotNull
    @Contract(pure=true)
    public static NamedPath.OngoingDefinitionWithName path(String name) {
        return NamedPath.named(name);
    }

    @NotNull
    @Contract(pure=true)
    public static NamedPath.OngoingDefinitionWithName path(SymbolicName name) {
        return NamedPath.named(name);
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static NamedPath.OngoingShortestPathDefinitionWithName shortestPath(String name) {
        return NamedPath.named(name, (FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SHORTEST_PATH);
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static NamedPath.OngoingShortestPathDefinitionWithName shortestPath(SymbolicName name) {
        return NamedPath.named(name, (FunctionInvocation.FunctionDefinition)BuiltInFunctions.Scalars.SHORTEST_PATH);
    }

    public static NamedPath.OngoingShortestDefinition shortestK(int k) {
        return NamedPath.shortest(k);
    }

    public static NamedPath.OngoingShortestDefinition shortestKGroups(int k) {
        return NamedPath.shortestKGroups(k);
    }

    public static NamedPath.OngoingShortestDefinition anyShortest() {
        return NamedPath.any();
    }

    public static NamedPath.OngoingShortestDefinition allShortest() {
        return NamedPath.allShortest();
    }

    @NotNull
    @Contract(pure=true)
    public static SymbolicName name(String value) {
        return SymbolicName.of(value);
    }

    @NotNull
    @Contract(pure=true)
    public static Parameter<Object> parameter(String name) {
        return Parameter.create(name);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Parameter<T> parameter(String name, T value) {
        return Parameter.create(name, value);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Parameter<T> anonParameter(T value) {
        return Parameter.anon(value);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere optionalMatch(PatternElement ... pattern) {
        return Statement.builder().optionalMatch(pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere optionalMatch(Collection<? extends PatternElement> pattern) {
        return Cypher.optionalMatch(pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere match(PatternElement ... pattern) {
        return Statement.builder().match(pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere match(Collection<? extends PatternElement> pattern) {
        return Cypher.match(pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, PatternElement ... pattern) {
        return Statement.builder().match(optional, pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere match(boolean optional, Collection<? extends PatternElement> pattern) {
        return Cypher.match(optional, pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUpdate create(PatternElement ... pattern) {
        return Statement.builder().create(pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUpdate create(Collection<? extends PatternElement> pattern) {
        return Cypher.create(pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(String ... variables) {
        return Statement.builder().with(variables);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(IdentifiableElement ... elements) {
        return Statement.builder().with(elements);
    }

    public static SubqueryExpressionBuilder subqueryWith(String ... identifiableElements) {
        return Cypher.subqueryWith((IdentifiableElement[])Arrays.stream(identifiableElements).map(SymbolicName::of).toArray(SymbolicName[]::new));
    }

    public static SubqueryExpressionBuilder subqueryWith(IdentifiableElement ... identifiableElements) {
        return Expressions.with(identifiableElements);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere with(Collection<IdentifiableElement> elements) {
        return Statement.builder().with(elements);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingMerge merge(PatternElement ... pattern) {
        return Statement.builder().merge(pattern);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingMerge merge(Collection<? extends PatternElement> pattern) {
        return Cypher.merge(pattern.toArray(new PatternElement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUnwind unwind(Expression expression) {
        return Statement.builder().unwind(expression);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUnwind unwind(Expression ... expressions) {
        return Statement.builder().unwind((Expression)Cypher.listOf(expressions));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingUnwind unwind(Collection<? extends Expression> expressions) {
        return Cypher.unwind(expressions.toArray(new Expression[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static SortItem sort(Expression expression) {
        return SortItem.create(expression, null);
    }

    @NotNull
    @Contract(pure=true)
    public static SortItem sort(Expression expression, SortItem.Direction direction) {
        return SortItem.create(expression, direction);
    }

    @NotNull
    @Contract(pure=true)
    public static MapExpression mapOf(Object ... keysAndValues) {
        return MapExpression.create(false, keysAndValues);
    }

    @NotNull
    @Contract(pure=true)
    public static MapExpression sortedMapOf(Object ... keysAndValues) {
        return MapExpression.create(true, keysAndValues);
    }

    @NotNull
    @Contract(pure=true)
    public static MapExpression asExpression(Map<String, Object> map) {
        return MapExpression.create(map);
    }

    @NotNull
    @Contract(pure=true)
    public static ListExpression listOf(Expression ... expressions) {
        return ListExpression.create(expressions);
    }

    @NotNull
    @Contract(pure=true)
    public static ListExpression listOf(Collection<? extends Expression> expressions) {
        return Cypher.listOf(expressions.toArray(new Expression[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Literal<T> literalOf(Object object) {
        if (object == null) {
            return NullLiteral.INSTANCE;
        }
        if (object instanceof Literal) {
            return (Literal)object;
        }
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            return new StringLiteral(charSequence);
        }
        if (object instanceof Character) {
            return new StringLiteral(String.valueOf(object));
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return new NumberLiteral(number);
        }
        if (object instanceof TemporalAccessor) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)object;
            return new TemporalLiteral(temporalAccessor);
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return DurationLiteral.of(duration);
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return PeriodLiteral.of(period);
        }
        if (object instanceof Iterable || object.getClass().isArray()) {
            ArrayList elements = new ArrayList();
            Consumer<Object> handleElement = element -> {
                if (element instanceof Literal) {
                    elements.add((Literal)element);
                } else {
                    try {
                        elements.add(Cypher.literalOf(element));
                    }
                    catch (Literal.UnsupportedLiteralException e) {
                        throw new Literal.UnsupportedLiteralException("Unsupported literal type in iterable.", element);
                    }
                }
            };
            if (object.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    handleElement.accept(Array.get(object, i));
                }
            } else {
                ((Iterable)object).forEach(handleElement);
            }
            ListLiteral listLiteral = new ListLiteral(elements);
            return listLiteral;
        }
        if (object instanceof Map) {
            LinkedHashMap map = new LinkedHashMap();
            BiConsumer<Object, Object> handleEntry = (key, value) -> {
                if (!(key instanceof CharSequence) && !(key instanceof Character)) {
                    throw new Literal.UnsupportedLiteralException("Unsupported literal map key (not a string/char type).", key);
                }
                if (value instanceof Literal) {
                    map.put(key.toString(), (Literal)value);
                } else {
                    try {
                        map.put(key.toString(), Cypher.literalOf(value));
                    }
                    catch (Literal.UnsupportedLiteralException e) {
                        throw new Literal.UnsupportedLiteralException("Unsupported literal type in map.", value);
                    }
                }
            };
            ((Map)object).forEach(handleEntry);
            MapLiteral mapLiteral = new MapLiteral(map);
            return mapLiteral;
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            return BooleanLiteral.of(b);
        }
        throw new Literal.UnsupportedLiteralException(object);
    }

    @NotNull
    @Contract(pure=true)
    public static Literal<Boolean> literalTrue() {
        return BooleanLiteral.TRUE;
    }

    @NotNull
    @Contract(pure=true)
    public static Literal<Boolean> literalFalse() {
        return BooleanLiteral.FALSE;
    }

    @NotNull
    @Contract(pure=true)
    public static Literal<Void> literalNull() {
        return NullLiteral.INSTANCE;
    }

    @NotNull
    @Contract(pure=true)
    public static Statement.UnionQuery union(Statement ... statements) {
        return Cypher.unionImpl(false, statements);
    }

    @NotNull
    @Contract(pure=true)
    public static Statement.UnionQuery union(Collection<Statement> statements) {
        return Cypher.union(statements.toArray(new Statement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static Statement unionAll(Statement ... statements) {
        return Cypher.unionImpl(true, statements);
    }

    @NotNull
    @Contract(pure=true)
    public static Statement unionAll(Collection<Statement> statements) {
        return Cypher.unionAll(statements.toArray(new Statement[0]));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingAndReturn returning(Expression ... expressions) {
        return Statement.builder().returning(expressions);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingAndReturn returning(Collection<? extends Expression> expressions) {
        return Statement.builder().returning(expressions);
    }

    @NotNull
    @Contract(pure=true)
    public static PatternComprehension.OngoingDefinitionWithPattern listBasedOn(RelationshipPattern relationshipPattern) {
        return PatternComprehension.basedOn(relationshipPattern);
    }

    @NotNull
    @Contract(pure=true)
    public static PatternComprehension.OngoingDefinitionWithPattern listBasedOn(NamedPath namedPath) {
        return PatternComprehension.basedOn(namedPath);
    }

    @NotNull
    @Contract(pure=true)
    public static ListComprehension.OngoingDefinitionWithVariable listWith(SymbolicName variable) {
        return ListComprehension.with(variable);
    }

    @NotNull
    @Contract(pure=true)
    public static String quote(String unquotedString) {
        return Cypher.literalOf(unquotedString).asString();
    }

    @NotNull
    @Contract(pure=true)
    public static Case caseExpression() {
        return Case.create(null);
    }

    @NotNull
    @Contract(pure=true)
    public static Case caseExpression(@Nullable Expression expression) {
        return Case.create(expression);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String procedureName) {
        Assertions.hasText(procedureName, "The procedure name must not be null or empty.");
        return Cypher.call(procedureName.split("\\."));
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(String ... namespaceAndProcedure) {
        return Statement.call(namespaceAndProcedure);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingStandaloneCallWithoutArguments call(Collection<String> namespaceAndProcedure) {
        return Cypher.call(namespaceAndProcedure.toArray(new String[0]));
    }

    @Neo4jVersion(minimum="4.0.0")
    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingWithoutWhere call(Statement subquery) {
        return Statement.builder().call(subquery);
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subList(Expression targetExpression, Integer start, Integer end) {
        return ListOperator.subList(targetExpression, Cypher.literalOf(start), Cypher.literalOf(end));
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subList(Expression targetExpression, Expression start, Expression end) {
        return ListOperator.subList(targetExpression, start, end);
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subListFrom(Expression targetExpression, Integer start) {
        return ListOperator.subListFrom(targetExpression, Cypher.literalOf(start));
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subListFrom(Expression targetExpression, Expression start) {
        return ListOperator.subListFrom(targetExpression, start);
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subListUntil(Expression targetExpression, Integer end) {
        return ListOperator.subListUntil(targetExpression, Cypher.literalOf(end));
    }

    @NotNull
    @Contract(pure=true)
    public static Expression subListUntil(Expression targetExpression, Expression end) {
        return ListOperator.subListUntil(targetExpression, end);
    }

    @NotNull
    @Contract(pure=true)
    public static ListOperator valueAt(Expression targetExpression, Integer index) {
        return Cypher.valueAt(targetExpression, Cypher.literalOf(index));
    }

    @NotNull
    @Contract(pure=true)
    public static ListOperator valueAt(Expression targetExpression, Expression index) {
        return ListOperator.valueAt(targetExpression, index);
    }

    @NotNull
    @Contract(pure=true)
    public static Expression raw(String format, Object ... mixedArgs) {
        return RawLiteral.create(format, mixedArgs);
    }

    public static ExposesSubqueryCall.BuildableSubquery callRawCypher(String rawCypher, Object ... args) {
        return Statement.builder().callRawCypher(rawCypher, args);
    }

    @NotNull
    @Contract(pure=true)
    public static StatementBuilder.OngoingReadingAndReturn returningRaw(Expression rawExpression) {
        return Statement.builder().returningRaw(rawExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    @Contract(pure=true)
    public static <FE> ForeignAdapter<FE> adapt(FE expression) {
        ForeignAdapterFactory initializedForeignAdapterFactory = foreignAdapterFactory;
        if (initializedForeignAdapterFactory != null) return initializedForeignAdapterFactory.getAdapterFor(expression);
        Class<Cypher> clazz = Cypher.class;
        synchronized (Cypher.class) {
            initializedForeignAdapterFactory = foreignAdapterFactory;
            if (initializedForeignAdapterFactory != null) return initializedForeignAdapterFactory.getAdapterFor(expression);
            initializedForeignAdapterFactory = foreignAdapterFactory = new ForeignAdapterFactory();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return initializedForeignAdapterFactory.getAdapterFor(expression);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static ExposesLoadCSV usingPeriodicCommit() {
        return Cypher.usingPeriodicCommit(null);
    }

    @NotNull
    @Contract(pure=true)
    public static ExposesLoadCSV usingPeriodicCommit(@Nullable Integer rate) {
        return LoadCSVStatementBuilder.usingPeriodicCommit(rate);
    }

    public static LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI from) {
        return Cypher.loadCSV(from, false);
    }

    public static LoadCSVStatementBuilder.OngoingLoadCSV loadCSV(URI from, boolean withHeaders) {
        return LoadCSVStatementBuilder.loadCSV(from, withHeaders);
    }

    private static Statement.UnionQuery unionImpl(boolean unionAll, Statement ... statements) {
        Assertions.isTrue(statements != null && statements.length >= 2, "At least two statements are required!");
        int i = 0;
        UnionQueryImpl existingUnionQuery = null;
        boolean isUnionQuery = statements[0] instanceof UnionQueryImpl;
        if (isUnionQuery) {
            existingUnionQuery = (UnionQueryImpl)statements[0];
            Assertions.isTrue(existingUnionQuery.isAll() == unionAll, "Cannot mix union and union all!");
            i = 1;
        }
        ArrayList<Statement> listOfQueries = new ArrayList<Statement>();
        do {
            Assertions.isTrue(statements[i] instanceof Statement.SingleQuery || statements[i] instanceof ClausesBasedStatement, "Can only union single queries!");
            listOfQueries.add(statements[i]);
        } while (++i < statements.length);
        if (existingUnionQuery == null) {
            return UnionQueryImpl.create(unionAll, listOfQueries);
        }
        return existingUnionQuery.addAdditionalQueries(listOfQueries);
    }

    public static String format(Expression expression) {
        return Expressions.format(expression);
    }

    public static Statement.UseStatement use(String target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(Parameter<?> target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(StringLiteral target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Statement.UseStatement use(Expression target, Statement statement) {
        return DecoratedQuery.decorate(statement, UseClauseImpl.of(target));
    }

    public static Condition includesAll(Expression lhs, Expression rhs) {
        return Conditions.includesAll(lhs, rhs);
    }

    public static Condition includesAny(Expression lhs, Expression rhs) {
        return Conditions.includesAny(lhs, rhs);
    }

    public static Condition matching(RelationshipPattern relationshipPattern) {
        return Conditions.matching(relationshipPattern);
    }

    public static Condition matches(Expression lhs, Expression rhs) {
        return Conditions.matches(lhs, rhs);
    }

    public static Condition isEqualTo(Expression lhs, Expression rhs) {
        return Conditions.isEqualTo(lhs, rhs);
    }

    public static Condition isNotEqualTo(Expression lhs, Expression rhs) {
        return Conditions.isNotEqualTo(lhs, rhs);
    }

    public static Condition lt(Expression lhs, Expression rhs) {
        return Conditions.lt(lhs, rhs);
    }

    public static Condition lte(Expression lhs, Expression rhs) {
        return Conditions.lte(lhs, rhs);
    }

    public static Condition gte(Expression lhs, Expression rhs) {
        return Conditions.gte(lhs, rhs);
    }

    public static Condition gt(Expression lhs, Expression rhs) {
        return Conditions.gt(lhs, rhs);
    }

    @Contract(pure=true)
    @NotNull
    public static Condition not(@NotNull Condition condition) {
        return Conditions.not(condition);
    }

    @Contract(pure=true)
    @NotNull
    public static Condition not(@NotNull RelationshipPattern pattern) {
        return Conditions.not(pattern);
    }

    public static Condition startsWith(Expression lhs, Expression rhs) {
        return Conditions.startsWith(lhs, rhs);
    }

    public static Condition contains(Expression lhs, Expression rhs) {
        return Conditions.contains(lhs, rhs);
    }

    public static Condition endsWith(Expression lhs, Expression rhs) {
        return Conditions.endsWith(lhs, rhs);
    }

    @Contract(pure=true)
    @NotNull
    public static Condition noCondition() {
        return Conditions.noCondition();
    }

    public static Condition isNull(Expression expression) {
        return Conditions.isNull(expression);
    }

    public static Condition isNotNull(Expression expression) {
        return Conditions.isNotNull(expression);
    }

    public static Condition isEmpty(Expression expression) {
        return Predicates.isEmpty(expression);
    }

    public static Condition isTrue() {
        return Conditions.isTrue();
    }

    public static Condition isFalse() {
        return Conditions.isFalse();
    }

    public static Condition hasLabelsOrType(SymbolicName symbolicName, String ... labelsOrTypes) {
        return Conditions.hasLabelsOrType(symbolicName, labelsOrTypes);
    }

    @NotNull
    public static CountExpression count(PatternElement requiredPattern, PatternElement ... patternElement) {
        return Expressions.count(requiredPattern, patternElement);
    }

    @NotNull
    public static CountExpression count(Statement.UnionQuery union) {
        return Expressions.count(union);
    }

    @NotNull
    public static CountExpression count(Statement statement, IdentifiableElement ... imports) {
        return Expressions.count(statement, imports);
    }

    public static CountExpression count(List<PatternElement> pattern, @Nullable Where where) {
        return Expressions.count(pattern, where);
    }

    @NotNull
    public static Expression collect(Statement statement) {
        return Expressions.collect(statement);
    }

    public static <T extends Expression> Expression nameOrExpression(T expression) {
        return Expressions.nameOrExpression(expression);
    }

    public static SymbolicName[] createSymbolicNames(String[] variables) {
        return Expressions.createSymbolicNames(variables);
    }

    public static SymbolicName[] createSymbolicNames(Named[] variables) {
        return Expressions.createSymbolicNames(variables);
    }

    @Neo4jVersion(minimum="5.0.0")
    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation elementId(@NotNull Node node) {
        return Functions.elementId(node);
    }

    @Neo4jVersion(minimum="5.0.0")
    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation elementId(@NotNull Relationship relationship) {
        return Functions.elementId(relationship);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation keys(@NotNull Node node) {
        return Functions.keys(node);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation keys(@NotNull Relationship relationship) {
        return Functions.keys(relationship);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation keys(@NotNull Expression expression) {
        return Functions.keys(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation labels(@NotNull Node node) {
        return Functions.labels(node);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation labels(@NotNull SymbolicName node) {
        return Functions.labels(node);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation type(@NotNull Relationship relationship) {
        return Functions.type(relationship);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation type(@NotNull SymbolicName relationship) {
        return Functions.type(relationship);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation count(@NotNull Node node) {
        return Functions.count(node);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation count(Expression expression) {
        return Functions.count(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation countDistinct(@NotNull Node node) {
        return Functions.countDistinct(node);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation countDistinct(Expression expression) {
        return Functions.countDistinct(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation properties(Node node) {
        return Functions.properties(node);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation properties(Relationship relationship) {
        return Functions.properties(relationship);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation properties(MapExpression map) {
        return Functions.properties(map);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation coalesce(Expression ... expressions) {
        return Functions.coalesce(expressions);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation left(Expression expression, Expression length) {
        return Functions.left(expression, length);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation ltrim(@NotNull Expression expression) {
        return Functions.ltrim(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation replace(Expression original, Expression search, Expression replace) {
        return Functions.replace(original, search, replace);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation reverse(@NotNull Expression original) {
        return Functions.reverse(original);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation right(Expression expression, Expression length) {
        return Functions.right(expression, length);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation rtrim(@NotNull Expression expression) {
        return Functions.rtrim(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation substring(Expression original, Expression start, Expression length) {
        return Functions.substring(original, start, length);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation toLower(@NotNull Expression expression) {
        return Functions.toLower(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation toUpper(@NotNull Expression expression) {
        return Functions.toUpper(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation trim(@NotNull Expression expression) {
        return Functions.trim(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation split(@NotNull Expression expression, @NotNull Expression delimiter) {
        return Functions.split(expression, delimiter);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation split(@NotNull Expression expression, @NotNull String delimiter) {
        return Functions.split(expression, delimiter);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation size(Expression expression) {
        return Functions.size(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation size(RelationshipPattern pattern) {
        return Functions.size(pattern);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation exists(Expression expression) {
        return Functions.exists(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation distance(@NotNull Expression point1, @NotNull Expression point2) {
        return Functions.distance(point1, point2);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation point(MapExpression parameterMap) {
        return Functions.point(parameterMap);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation point(Expression expression) {
        return Functions.point(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation point(Parameter<?> parameter) {
        return Functions.point(parameter);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation cartesian(double x, double y) {
        return Functions.cartesian(x, y);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation coordinate(double longitude, double latitude) {
        return Functions.coordinate(longitude, latitude);
    }

    public static FunctionInvocation withinBBox(Expression point, Expression lowerLeft, Expression upperRight) {
        return Functions.withinBBox(point, lowerLeft, upperRight);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation avg(Expression expression) {
        return Functions.avg(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation avgDistinct(Expression expression) {
        return Functions.avgDistinct(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation collect(@NotNull Named variable) {
        return Functions.collect(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation collectDistinct(@NotNull Named variable) {
        return Functions.collectDistinct(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation collect(Expression expression) {
        return Functions.collect(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation collectDistinct(Expression expression) {
        return Functions.collectDistinct(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation max(Expression expression) {
        return Functions.max(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation maxDistinct(Expression expression) {
        return Functions.maxDistinct(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation min(Expression expression) {
        return Functions.min(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation minDistinct(Expression expression) {
        return Functions.minDistinct(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation percentileCont(Expression expression, Number percentile) {
        return Functions.percentileCont(expression, percentile);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation percentileContDistinct(Expression expression, Number percentile) {
        return Functions.percentileContDistinct(expression, percentile);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation percentileDisc(Expression expression, Number percentile) {
        return Functions.percentileDisc(expression, percentile);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation percentileDiscDistinct(Expression expression, Number percentile) {
        return Functions.percentileDiscDistinct(expression, percentile);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation stDev(Expression expression) {
        return Functions.stDev(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation stDevDistinct(Expression expression) {
        return Functions.stDevDistinct(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation stDevP(Expression expression) {
        return Functions.stDevP(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation stDevPDistinct(Expression expression) {
        return Functions.stDevPDistinct(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation sum(Expression expression) {
        return Functions.sum(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation sumDistinct(Expression expression) {
        return Functions.sumDistinct(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation range(Integer start, Integer end) {
        return Functions.range(start, end);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation range(@NotNull Expression start, @NotNull Expression end) {
        return Functions.range(start, end);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation range(@NotNull Integer start, @NotNull Integer end, Integer step) {
        return Functions.range(start, end, step);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation range(@NotNull Expression start, @NotNull Expression end, Expression step) {
        return Functions.range(start, end, step);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation head(Expression expression) {
        return Functions.head(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation last(Expression expression) {
        return Functions.last(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation nodes(@NotNull NamedPath path) {
        return Functions.nodes(path);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation nodes(@NotNull SymbolicName symbolicName) {
        return Functions.nodes(symbolicName);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation relationships(@NotNull NamedPath path) {
        return Functions.relationships(path);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation relationships(@NotNull SymbolicName symbolicName) {
        return Functions.relationships(symbolicName);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation startNode(@NotNull Relationship relationship) {
        return Functions.startNode(relationship);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation endNode(@NotNull Relationship relationship) {
        return Functions.endNode(relationship);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation date() {
        return Functions.date();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation calendarDate(Integer year, Integer month, Integer day) {
        return Functions.calendarDate(year, month, day);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation weekDate(Integer year, Integer week, Integer dayOfWeek) {
        return Functions.weekDate(year, week, dayOfWeek);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation quarterDate(Integer year, Integer quarter, Integer dayOfQuarter) {
        return Functions.quarterDate(year, quarter, dayOfQuarter);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation ordinalDate(Integer year, Integer ordinalDay) {
        return Functions.ordinalDate(year, ordinalDay);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation date(@NotNull MapExpression components) {
        return Functions.date(components);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation date(@NotNull String temporalValue) {
        return Functions.date(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation date(@NotNull Expression temporalValue) {
        return Functions.date(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation datetime() {
        return Functions.datetime();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation datetime(@NotNull TimeZone timeZone) {
        return Functions.datetime(timeZone);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation datetime(@NotNull MapExpression components) {
        return Functions.datetime(components);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation datetime(@NotNull String temporalValue) {
        return Functions.datetime(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation datetime(@NotNull Expression temporalValue) {
        return Functions.datetime(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localdatetime() {
        return Functions.localdatetime();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localdatetime(@NotNull TimeZone timeZone) {
        return Functions.localdatetime(timeZone);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localdatetime(@NotNull MapExpression components) {
        return Functions.localdatetime(components);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localdatetime(@NotNull String temporalValue) {
        return Functions.localdatetime(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localdatetime(@NotNull Expression temporalValue) {
        return Functions.localdatetime(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localtime() {
        return Functions.localtime();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localtime(@NotNull TimeZone timeZone) {
        return Functions.localtime(timeZone);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localtime(@NotNull MapExpression components) {
        return Functions.localtime(components);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localtime(@NotNull String temporalValue) {
        return Functions.localtime(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation localtime(@NotNull Expression temporalValue) {
        return Functions.localtime(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation time() {
        return Functions.time();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation time(@NotNull TimeZone timeZone) {
        return Functions.time(timeZone);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation time(@NotNull MapExpression components) {
        return Functions.time(components);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation time(@NotNull String temporalValue) {
        return Functions.time(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation time(@NotNull Expression temporalValue) {
        return Functions.time(temporalValue);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation duration(@NotNull MapExpression components) {
        return Functions.duration(components);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation duration(@NotNull String temporalAmount) {
        return Functions.duration(temporalAmount);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation duration(@NotNull Expression temporalAmount) {
        return Functions.duration(temporalAmount);
    }

    @Deprecated
    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation shortestPath(Relationship relationship) {
        return Functions.shortestPath(relationship);
    }

    @Contract(pure=true)
    @NotNull
    public static Reduction.OngoingDefinitionWithVariable reduce(@NotNull SymbolicName variable) {
        return Functions.reduce(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation abs(@NotNull Expression expression) {
        return Functions.abs(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation ceil(@NotNull Expression expression) {
        return Functions.ceil(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation floor(@NotNull Expression expression) {
        return Functions.floor(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation rand() {
        return Functions.rand();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation round(Expression value, Expression ... expression) {
        return Functions.round(value, expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation sign(@NotNull Expression expression) {
        return Functions.sign(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation e() {
        return Functions.e();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation exp(@NotNull Expression expression) {
        return Functions.exp(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation log(@NotNull Expression expression) {
        return Functions.log(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation log10(@NotNull Expression expression) {
        return Functions.log10(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation sqrt(@NotNull Expression expression) {
        return Functions.sqrt(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation acos(@NotNull Expression expression) {
        return Functions.acos(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation asin(@NotNull Expression expression) {
        return Functions.asin(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation atan(@NotNull Expression expression) {
        return Functions.atan(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation atan2(@NotNull Expression y, @NotNull Expression x) {
        return Functions.atan2(y, x);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation cos(@NotNull Expression expression) {
        return Functions.cos(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation cot(@NotNull Expression expression) {
        return Functions.cot(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation degrees(@NotNull Expression expression) {
        return Functions.degrees(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation haversin(@NotNull Expression expression) {
        return Functions.haversin(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation pi() {
        return Functions.pi();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation radians(@NotNull Expression expression) {
        return Functions.radians(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation sin(@NotNull Expression expression) {
        return Functions.sin(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation tan(@NotNull Expression expression) {
        return Functions.tan(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation toInteger(@NotNull Expression expression) {
        return Functions.toInteger(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation toString(@NotNull Expression expression) {
        return Functions.toString(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation toStringOrNull(@NotNull Expression expression) {
        return Functions.toStringOrNull(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation toFloat(@NotNull Expression expression) {
        return Functions.toFloat(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation toBoolean(@NotNull Expression expression) {
        return Functions.toBoolean(expression);
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation linenumber() {
        return Functions.linenumber();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation file() {
        return Functions.file();
    }

    public static FunctionInvocation randomUUID() {
        return Functions.randomUUID();
    }

    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation length(@NotNull NamedPath path) {
        return Functions.length(path);
    }

    @Neo4jVersion(minimum="5.0.0")
    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation graphNames() {
        return Functions.graphNames();
    }

    @Neo4jVersion(minimum="5.0.0")
    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation graphPropertiesByName(Expression name) {
        return Functions.graphPropertiesByName(name);
    }

    @Neo4jVersion(minimum="5.0.0")
    @Contract(pure=true)
    @NotNull
    public static FunctionInvocation graphByName(Expression name) {
        return Functions.graphByName(name);
    }

    public static MapProjection createProjection(SymbolicName name, Object ... content) {
        return MapProjection.create(name, content);
    }

    public static Operation minus(Expression e) {
        return Operations.minus(e);
    }

    public static Expression plus(Expression e) {
        return Operations.plus(e);
    }

    public static Operation concat(Expression op1, Expression op2) {
        return Operations.concat(op1, op2);
    }

    public static Operation add(Expression op1, Expression op2) {
        return Operations.add(op1, op2);
    }

    public static Operation subtract(Expression op1, Expression op2) {
        return Operations.subtract(op1, op2);
    }

    public static Operation multiply(Expression op1, Expression op2) {
        return Operations.multiply(op1, op2);
    }

    public static Operation divide(Expression op1, Expression op2) {
        return Operations.divide(op1, op2);
    }

    public static Operation remainder(Expression op1, Expression op2) {
        return Operations.remainder(op1, op2);
    }

    public static Operation pow(Expression op1, Expression op2) {
        return Operations.pow(op1, op2);
    }

    public static Operation set(Expression target, Expression value) {
        return Operations.set(target, value);
    }

    public static Operation mutate(Expression target, MapExpression value) {
        return Operations.mutate(target, value);
    }

    public static Operation mutate(Expression target, Expression value) {
        return Operations.mutate(target, value);
    }

    public static Operation setLabel(Node target, String ... label) {
        return Operations.set(target, label);
    }

    public static Operation removeLabel(Node target, String ... label) {
        return Operations.remove(target, label);
    }

    @Contract(pure=true)
    @NotNull
    public static Condition exists(Property property) {
        return Predicates.exists(property);
    }

    @Contract(pure=true)
    @NotNull
    public static Condition exists(RelationshipPattern pattern) {
        return Predicates.exists(pattern);
    }

    public static Condition exists(Statement statement, IdentifiableElement ... imports) {
        return Predicates.exists(statement, imports);
    }

    public static Condition exists(PatternElement pattern) {
        return Predicates.exists(pattern);
    }

    public static Condition exists(List<PatternElement> pattern) {
        return Predicates.exists(pattern);
    }

    public static Condition exists(List<PatternElement> pattern, @Nullable Where where) {
        return Predicates.exists(pattern, where);
    }

    @Contract(pure=true)
    @NotNull
    public static OngoingListBasedPredicateFunction all(String variable) {
        return Predicates.all(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static OngoingListBasedPredicateFunction all(SymbolicName variable) {
        return Predicates.all(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static OngoingListBasedPredicateFunction any(String variable) {
        return Predicates.any(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static OngoingListBasedPredicateFunction any(SymbolicName variable) {
        return Predicates.any(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static OngoingListBasedPredicateFunction none(String variable) {
        return Predicates.none(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static OngoingListBasedPredicateFunction none(SymbolicName variable) {
        return Predicates.none(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static OngoingListBasedPredicateFunction single(String variable) {
        return Predicates.single(variable);
    }

    @Contract(pure=true)
    @NotNull
    public static OngoingListBasedPredicateFunction single(SymbolicName variable) {
        return Predicates.single(variable);
    }

    private Cypher() {
    }
}

