/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AbstractStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Clause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Return;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.UsingPeriodicCommit;

@API(status=API.Status.INTERNAL, since="2021.3.0")
class ClausesBasedStatement
extends AbstractStatement {
    private final UsingPeriodicCommit optionalPeriodicCommit;
    private final List<Clause> clauses;

    ClausesBasedStatement(@NotNull List<Clause> clauses, @Nullable UsingPeriodicCommit optionalPeriodicCommit) {
        this.optionalPeriodicCommit = optionalPeriodicCommit;
        this.clauses = List.copyOf(clauses);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Visitable.visitIfNotNull(this.optionalPeriodicCommit, visitor);
        this.clauses.forEach(c -> c.accept(visitor));
        visitor.leave(this);
    }

    @Override
    public boolean doesReturnOrYield() {
        if (this.clauses.isEmpty()) {
            return false;
        }
        Clause lastClause = this.clauses.get(this.clauses.size() - 1);
        return lastClause instanceof Return;
    }

    @API(status=API.Status.INTERNAL)
    List<Clause> getClauses() {
        return this.clauses;
    }
}

