/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Arguments;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Clause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Create;
import org.neo4j.jdbc.internal.shaded.cypherdsl.DefaultStatementBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Delete;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Foreach;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Hint;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Match;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Merge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MergeAction;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Pattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ProcedureCallImpl;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Remove;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Return;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Set;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SortItem;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StringLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Subquery;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Unwind;
import org.neo4j.jdbc.internal.shaded.cypherdsl.UpdatingClause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.With;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.LoadCSV;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.ProcedureName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.YieldItems;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="2021.3.0")
public final class Clauses {
    @NotNull
    public static Clause match(boolean optional, List<PatternElement> patternElements, @Nullable Where optionalWhere, @Nullable List<Hint> optionalHints) {
        return new Match(optional, Pattern.of(patternElements), optionalWhere, optionalHints);
    }

    @NotNull
    public static Clause delete(boolean detach, List<Expression> expressions) {
        return new Delete(new ExpressionList(expressions), detach);
    }

    @NotNull
    public static Return returning(boolean distinct, List<Expression> expressions, @Nullable List<SortItem> optionalSortItems, @Nullable Expression optionalSkip, @Nullable Expression optionalLimit) {
        DefaultStatementBuilder.OrderBuilder orderBuilder = new DefaultStatementBuilder.OrderBuilder();
        orderBuilder.orderBy(optionalSortItems);
        orderBuilder.skip(optionalSkip);
        orderBuilder.limit(optionalLimit);
        return Return.create(false, distinct, expressions, orderBuilder);
    }

    @NotNull
    public static Clause create(List<PatternElement> patternElements) {
        return new Create(Pattern.of(patternElements));
    }

    @NotNull
    public static Clause merge(List<PatternElement> patternElements, @Nullable List<MergeAction> mergeActions) {
        return new Merge(Pattern.of(patternElements), mergeActions == null ? Collections.emptyList() : mergeActions);
    }

    public static Clause with(Return returnClause, @Nullable Where optionalWhere) {
        return new With(returnClause, optionalWhere);
    }

    public static Clause remove(List<Expression> expressions) {
        return new Remove(new ExpressionList(expressions));
    }

    public static Clause set(List<Expression> expressions) {
        return new Set(new ExpressionList(expressions));
    }

    public static Clause unwind(Expression expression, SymbolicName name) {
        return new Unwind(expression, name.getValue());
    }

    public static Clause loadCSV(boolean withHeaders, StringLiteral uri, SymbolicName alias, @Nullable String fieldTerminator) {
        return new LoadCSV(URI.create(uri.getContent().toString()), withHeaders, alias.getValue()).withFieldTerminator(fieldTerminator);
    }

    public static Clause callClause(List<String> namespace, String name, @Nullable List<Expression> arguments, @Nullable List<Expression> resultItems, @Nullable Where optionalWhere) {
        return ProcedureCallImpl.create(ProcedureName.from(namespace, name), new Arguments(arguments == null ? new Expression[]{} : arguments.toArray(new Expression[0])), resultItems == null ? null : YieldItems.yieldAllOf(resultItems.toArray(new Expression[0])), optionalWhere);
    }

    public static Clause callClause(Statement statement) {
        return Subquery.call(statement, new IdentifiableElement[0]);
    }

    public static Clause forEach(SymbolicName v, Expression list, List<Clause> updatingClauses) {
        Assertions.isTrue(updatingClauses.stream().allMatch(UpdatingClause.class::isInstance), "Only updating clauses SET, REMOVE, CREATE, MERGE, DELETE, and FOREACH are allowed as clauses applied inside FOREACH.");
        return new Foreach(v, list, updatingClauses.stream().map(UpdatingClause.class::cast).toList());
    }

    private Clauses() {
    }
}

