/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Literal;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LiteralBase;

@API(status=API.Status.STABLE, since="1.0")
public final class BooleanLiteral
extends LiteralBase<Boolean> {
    static final BooleanLiteral TRUE = new BooleanLiteral(true);
    static final BooleanLiteral FALSE = new BooleanLiteral(false);

    static Literal<Boolean> of(@Nullable Boolean value) {
        if (value != null && value.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    private BooleanLiteral(boolean content) {
        super(content);
    }

    @Override
    @NotNull
    public String asString() {
        return this.getContent().toString();
    }

    @Override
    public Boolean getContent() {
        return (Boolean)this.content;
    }
}

