/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementCatalog;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementCatalogBuildingVisitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementContext;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.DefaultStatementContext;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Renderer;

@API(status=API.Status.INTERNAL, since="2021.0.0")
abstract class AbstractStatement
implements Statement {
    private final StatementContext context = new DefaultStatementContext();
    private boolean renderConstantsAsParameters = false;
    private volatile String cypher;
    private volatile StatementCatalog statementCatalog;

    AbstractStatement() {
    }

    @Override
    @NotNull
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public synchronized boolean isRenderConstantsAsParameters() {
        return this.renderConstantsAsParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRenderConstantsAsParameters(boolean renderConstantsAsParameters) {
        AbstractStatement abstractStatement = this;
        synchronized (abstractStatement) {
            this.renderConstantsAsParameters = renderConstantsAsParameters;
            this.cypher = null;
            this.statementCatalog = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getCypher() {
        String result = this.cypher;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.cypher;
                if (result == null) {
                    result = this.cypher = Renderer.getDefaultRenderer().render(this);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StatementCatalog getCatalog() {
        StatementCatalog result = this.statementCatalog;
        if (result == null) {
            AbstractStatement abstractStatement = this;
            synchronized (abstractStatement) {
                result = this.statementCatalog;
                if (result == null) {
                    result = this.statementCatalog = this.getCatalog0();
                }
            }
        }
        return result;
    }

    private StatementCatalog getCatalog0() {
        StatementCatalogBuildingVisitor catalogBuildingVisitor = new StatementCatalogBuildingVisitor(this.getContext(), this.isRenderConstantsAsParameters());
        this.accept(catalogBuildingVisitor);
        return catalogBuildingVisitor.getResult();
    }
}

