/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.message.RunMessage;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.AbstractMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.HttpContext;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.Query;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.QueryCounters;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.QueryData;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.QueryResult;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.RunSummaryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.TransactionInfo;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSON;

final class RunMessageHandler
extends AbstractMessageHandler<Query> {
    private final System.Logger log;
    private final ResponseHandler handler;
    private final HttpContext httpContext;
    private final Supplier<String> authHeaderSupplier;
    private final HttpRequest.BodyPublisher bodyPublisher;
    private final ValueFactory valueFactory;
    private final RunMessage message;
    private final Supplier<TransactionInfo> transactionInfoSupplier;
    private final AtomicReference<String> databaseName = new AtomicReference();
    private final String defaultDatabase;
    private final Duration readTimeout;

    RunMessageHandler(ResponseHandler handler, HttpContext httpContext, Supplier<String> authHeaderSupplier, RunMessage message, Supplier<TransactionInfo> transactionInfoSupplier, Duration readTimeout, ValueFactory valueFactory, LoggingProvider logging) {
        super(httpContext, handler, valueFactory, logging);
        RunMessage.Extra extra;
        this.log = logging.getLog(this.getClass());
        this.handler = Objects.requireNonNull(handler);
        this.httpContext = Objects.requireNonNull(httpContext);
        this.authHeaderSupplier = Objects.requireNonNull(authHeaderSupplier);
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.message = Objects.requireNonNull(message);
        this.transactionInfoSupplier = Objects.requireNonNull(transactionInfoSupplier);
        this.readTimeout = readTimeout;
        if (message.extra().isPresent() && (extra = message.extra().get()).databaseName().isEmpty() && httpContext.defaultDatabase() == null) {
            throw new BoltClientException("Database name must be specified");
        }
        this.bodyPublisher = this.newHttpRequestBodyPublisher(httpContext.json(), message);
        this.defaultDatabase = httpContext.defaultDatabase();
    }

    @Override
    protected HttpRequest newHttpRequest() {
        URI uri;
        String databaseName;
        TransactionInfo transactionInfo = this.transactionInfoSupplier.get();
        String[] headers = this.httpContext.headers(this.authHeaderSupplier.get());
        if (transactionInfo != null) {
            databaseName = transactionInfo.databaseName();
            uri = this.httpContext.txUrl(transactionInfo);
            if (transactionInfo.affinity() != null) {
                headers = Arrays.copyOf(headers, headers.length + 2);
                headers[headers.length - 2] = "neo4j-cluster-affinity";
                headers[headers.length - 1] = transactionInfo.affinity();
            }
        } else {
            databaseName = this.message.extra().flatMap(extra -> extra.databaseName()).orElse(this.defaultDatabase);
            if (databaseName == null) {
                throw new BoltClientException("Database not specified");
            }
            uri = this.httpContext.queryUrl(databaseName);
        }
        this.databaseName.set(databaseName);
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).headers(headers).POST(this.bodyPublisher);
        if (this.readTimeout != null) {
            builder = builder.timeout(this.readTimeout);
        }
        return builder.build();
    }

    @Override
    protected Query handleResponse(HttpResponse<String> response) {
        List<Map<String, Object>> notifications;
        QueryResult queryResult;
        String body = response.body();
        try {
            this.log.log(System.Logger.Level.DEBUG, () -> "received body: " + body);
            queryResult = this.httpContext.json().beanFrom(QueryResult.class, body);
        }
        catch (IOException e) {
            throw new BoltClientException("Cannot parse response %s to QueryResult".formatted(body), e);
        }
        long id = new Random().nextLong();
        QueryCounters counters = queryResult.counters();
        Map statsMap = counters == null ? Map.of() : Map.ofEntries(Map.entry("nodes-created", this.valueFactory.value(counters.nodesCreated())), Map.entry("nodes-deleted", this.valueFactory.value(counters.nodesDeleted())), Map.entry("relationships-created", this.valueFactory.value(counters.relationshipsCreated())), Map.entry("relationships-deleted", this.valueFactory.value(counters.relationshipsDeleted())), Map.entry("properties-set", this.valueFactory.value(counters.propertiesSet())), Map.entry("labels-added", this.valueFactory.value(counters.labelsAdded())), Map.entry("labels-removed", this.valueFactory.value(counters.labelsRemoved())), Map.entry("indexes-added", this.valueFactory.value(counters.indexesAdded())), Map.entry("indexes-removed", this.valueFactory.value(counters.indexesRemoved())), Map.entry("constraints-added", this.valueFactory.value(counters.constraintsAdded())), Map.entry("constraints-removed", this.valueFactory.value(counters.constraintsRemoved())), Map.entry("system-updates", this.valueFactory.value(counters.systemUpdates())));
        String bookmark = null;
        if (queryResult.bookmarks() != null && !queryResult.bookmarks().isEmpty()) {
            if (queryResult.bookmarks().size() > 1) {
                this.log.log(System.Logger.Level.WARNING, "Found multiple bookmarks in run request");
                bookmark = queryResult.bookmarks().get(0);
            } else {
                bookmark = queryResult.bookmarks().get(0);
            }
        }
        String databaseName = this.databaseName.get();
        HashMap<String, Value> metadata = new HashMap<String, Value>();
        metadata.put("stats", this.valueFactory.value((Object)statsMap));
        metadata.put("db", this.valueFactory.value(databaseName));
        if (bookmark != null) {
            metadata.put("bookmark", this.valueFactory.value(bookmark));
        }
        if ((notifications = queryResult.notifications()) != null && !notifications.isEmpty()) {
            metadata.put("notifications", this.valueFactory.value(notifications));
        }
        QueryData data = Objects.requireNonNullElseGet(queryResult.data(), QueryData::empty);
        Query query = new Query(id, data.fields(), data.values(), Collections.unmodifiableMap(metadata));
        this.handler.onRunSummary(new RunSummaryImpl(query.id(), query.fields(), -1L, databaseName));
        return query;
    }

    private HttpRequest.BodyPublisher newHttpRequestBodyPublisher(JSON json, RunMessage message) {
        String statement = message.query();
        Map<String, Value> parameters = null;
        if (!message.parameters().isEmpty()) {
            parameters = message.parameters();
        }
        String accessMode = null;
        String impersonatedUser = null;
        ArrayList<String> bookmarks = null;
        if (message.extra().isPresent()) {
            RunMessage.Extra extra = message.extra().get();
            if (extra.accessMode() == AccessMode.READ) {
                accessMode = "Read";
            }
            impersonatedUser = extra.impersonatedUser().orElseGet(() -> null);
            if (!extra.bookmarks().isEmpty()) {
                bookmarks = new ArrayList<String>(extra.bookmarks());
            }
        }
        QueryAPIRequestPayload payload = new QueryAPIRequestPayload(statement, parameters, bookmarks, impersonatedUser, accessMode);
        try {
            String jsonBody = json.asString(payload);
            return HttpRequest.BodyPublishers.ofString(jsonBody);
        }
        catch (IOException e) {
            throw new BoltClientException("Cannot serialize payload %s".formatted(payload), e);
        }
    }

    private static class QueryAPIRequestPayload {
        private final String statement;
        private final Map<String, Value> parameters;
        private final List<String> bookmarks;
        private final String impersonatedUser;
        private final String accessMode;
        private final Boolean includeCounters = true;

        public QueryAPIRequestPayload(String statement, Map<String, Value> parameters, List<String> bookmarks, String impersonatedUser, String accessMode) {
            this.statement = statement;
            this.parameters = parameters;
            this.bookmarks = bookmarks;
            this.impersonatedUser = impersonatedUser;
            this.accessMode = accessMode;
        }

        public Map<String, Value> getParameters() {
            return this.parameters;
        }

        public String getStatement() {
            return this.statement;
        }

        public List<String> getBookmarks() {
            return this.bookmarks;
        }

        public String getAccessMode() {
            return this.accessMode;
        }

        public Boolean getIncludeCounters() {
            return this.includeCounters;
        }

        public String getImpersonatedUser() {
            return this.impersonatedUser;
        }
    }
}

