/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.AbstractMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.HttpContext;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.TransactionInfo;
import org.neo4j.jdbc.internal.shaded.bolt.summary.RollbackSummary;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

final class RollbackMessageHandler
extends AbstractMessageHandler<Void> {
    private final System.Logger log;
    private final ResponseHandler handler;
    private final HttpContext httpContext;
    private final Supplier<String> authHeaderSupplier;
    private final Supplier<TransactionInfo> transactionInfoSupplier;
    private final Duration readTimeout;

    RollbackMessageHandler(ResponseHandler handler, HttpContext httpContext, Supplier<String> authHeaderSupplier, Supplier<TransactionInfo> transactionInfoSupplier, Duration readTimeout, ValueFactory valueFactory, LoggingProvider logging) {
        super(httpContext, handler, valueFactory, logging);
        this.log = logging.getLog(this.getClass());
        this.handler = Objects.requireNonNull(handler);
        this.httpContext = Objects.requireNonNull(httpContext);
        this.authHeaderSupplier = Objects.requireNonNull(authHeaderSupplier);
        this.transactionInfoSupplier = Objects.requireNonNull(transactionInfoSupplier);
        this.readTimeout = readTimeout;
    }

    @Override
    protected HttpRequest newHttpRequest() {
        TransactionInfo transactionInfo = this.transactionInfoSupplier.get();
        if (transactionInfo == null) {
            throw new BoltClientException("No transaction found");
        }
        URI uri = this.httpContext.txUrl(transactionInfo);
        String[] headers = this.httpContext.headers(this.authHeaderSupplier.get());
        if (transactionInfo.affinity() != null) {
            headers = Arrays.copyOf(headers, headers.length + 2);
            headers[headers.length - 2] = "neo4j-cluster-affinity";
            headers[headers.length - 1] = transactionInfo.affinity();
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).headers(headers).DELETE();
        if (this.readTimeout != null) {
            builder = builder.timeout(this.readTimeout);
        }
        return builder.build();
    }

    @Override
    protected Void handleResponse(HttpResponse<String> response) {
        this.handler.onRollbackSummary(new RollbackSummary(){});
        return null;
    }
}

