/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionState;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.MessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.summary.ResetSummary;

final class ResetMessageHandler
implements MessageHandler<Void> {
    private final Supplier<BoltConnectionState> stateSupplier;
    private final Consumer<BoltConnectionState> stateHandler;
    private final ResponseHandler handler;

    ResetMessageHandler(Supplier<BoltConnectionState> stateSupplier, Consumer<BoltConnectionState> stateHandler, ResponseHandler handler) {
        this.stateSupplier = Objects.requireNonNull(stateSupplier);
        this.stateHandler = Objects.requireNonNull(stateHandler);
        this.handler = Objects.requireNonNull(handler);
    }

    @Override
    public CompletionStage<Void> exchange() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        switch (this.stateSupplier.get()) {
            case OPEN: {
                this.stateHandler.accept(BoltConnectionState.OPEN);
                this.handler.onResetSummary(ResetSummaryImpl.INSTANCE);
                result.complete(null);
                break;
            }
            case ERROR: {
                result.completeExceptionally(new BoltClientException("It is not possible to reset connection is ERROR state"));
                break;
            }
            case FAILURE: {
                this.stateHandler.accept(BoltConnectionState.OPEN);
                this.handler.onResetSummary(ResetSummaryImpl.INSTANCE);
                result.complete(null);
                break;
            }
            case CLOSED: {
                result.completeExceptionally(new BoltClientException("It is not possible to reset closed connection"));
            }
        }
        return result;
    }

    private record ResetSummaryImpl() implements ResetSummary
    {
        static final ResetSummaryImpl INSTANCE = new ResetSummaryImpl();
    }
}

