/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLParameters;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.BoltAgent;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnection;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.MinVersionAcquisitionException;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.DiscoveryResponse;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.QueryApiBoltConnection;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSON;

public class QueryApiBoltConnectionProvider
implements BoltConnectionProvider {
    private final LoggingProvider logging;
    private final System.Logger logger;
    private final ValueFactory valueFactory;
    private final BoltProtocolVersion BOLT_PROTOCOL_VERSION = new BoltProtocolVersion(5, 4);
    private final Executor httpExecutor;
    private final Clock clock;

    public QueryApiBoltConnectionProvider(LoggingProvider logging, ValueFactory valueFactory, Clock clock) {
        this.logging = Objects.requireNonNull(logging);
        this.logger = logging.getLog(this.getClass());
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.httpExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public CompletionStage<BoltConnection> connect(URI uri, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        HttpClient httpClientWithTimeout;
        if (minVersion != null && minVersion.compareTo(this.BOLT_PROTOCOL_VERSION) > 0) {
            return CompletableFuture.failedStage(new MinVersionAcquisitionException("lower version", this.BOLT_PROTOCOL_VERSION));
        }
        if (notificationConfig != null && !notificationConfig.equals(NotificationConfig.defaultConfig())) {
            this.logger.log(System.Logger.Level.WARNING, "Setting notification config is not supported, server default will be used instead");
        }
        if ("http".equals(uri.getScheme()) && securityPlan != null) {
            this.logger.log(System.Logger.Level.WARNING, "Setting security plan when using http scheme is not supported, it will be ignored");
        }
        try {
            HttpClient.Builder builder = this.newHttpClientBuilder(securityPlan);
            if (connectTimeoutMillis > 0) {
                builder.connectTimeout(Duration.ofMillis(connectTimeoutMillis));
            }
            httpClientWithTimeout = builder.build();
        }
        catch (Exception ex) {
            return CompletableFuture.failedStage(ex);
        }
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri);
        if (userAgent != null) {
            requestBuilder.header("User-Agent", userAgent);
        }
        return httpClientWithTimeout.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() == 200) {
                try {
                    DiscoveryResponse discoveryResponse = JSON.std.beanFrom(DiscoveryResponse.class, response.body());
                    String serverAgent = "Neo4j/%s".formatted(discoveryResponse.neo4j_version());
                    HttpClient httpClient = this.newHttpClientBuilder(securityPlan).build();
                    return new QueryApiBoltConnection(this.valueFactory, httpClient, uri, authToken, userAgent, serverAgent, this.BOLT_PROTOCOL_VERSION, this.clock, this.logging);
                }
                catch (IOException e) {
                    throw new BoltClientException("Cannot parse %s to DiscoveryResponse".formatted(response.body()), e);
                }
            }
            throw new BoltClientException("Unexpected response code: " + response.statusCode());
        });
    }

    private HttpClient.Builder newHttpClientBuilder(SecurityPlan securityPlan) {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().executor(this.httpExecutor);
        if (securityPlan != null) {
            String endpointIdentificationAlgorithm;
            httpClientBuilder = httpClientBuilder.sslContext(securityPlan.sslContext());
            if (securityPlan.verifyHostname()) {
                if (securityPlan.expectedHostname() != null) {
                    throw new BoltClientException("SecurityPlan with expectedHostname is not supported");
                }
                endpointIdentificationAlgorithm = "HTTPS";
            } else {
                endpointIdentificationAlgorithm = null;
            }
            SSLParameters sslParameters = new SSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(endpointIdentificationAlgorithm);
            httpClientBuilder = httpClientBuilder.sslParameters(sslParameters);
        }
        return httpClientBuilder;
    }

    @Override
    public CompletionStage<Void> close() {
        return CompletableFuture.completedStage(null);
    }
}

