/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.TransactionInfo;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSON;

public record HttpContext(HttpClient httpClient, URI baseUri, JSON json, String defaultDatabase, String userAgent) {
    private static final String DEFAULT_DATABASE_KEY_NAME = "defaultDatabase";

    public HttpContext {
        String query;
        String path = baseUri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((query = baseUri.getQuery()) != null) {
            for (String pair : query.split("&")) {
                String value;
                String key;
                String[] keyAndValue = pair.split("=");
                if (keyAndValue.length != 2 || !DEFAULT_DATABASE_KEY_NAME.equals(key = keyAndValue[0]) || (value = keyAndValue[1].trim()).isEmpty()) continue;
                defaultDatabase = value;
            }
        }
        try {
            baseUri = new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new BoltClientException("Invalid URI", e);
        }
    }

    public HttpContext(HttpClient httpClient, URI baseUri, JSON json, String userAgent) {
        this(httpClient, baseUri, json, null, userAgent);
    }

    public String[] headers(String authHeader) {
        return HttpContext.headers(authHeader, this.userAgent);
    }

    private static String[] headers(String authHeader, String userAgent) {
        String[] headers = new String[userAgent != null ? 8 : 6];
        headers[0] = "Content-Type";
        headers[1] = "application/vnd.neo4j.query";
        headers[2] = "Accept";
        headers[3] = "application/vnd.neo4j.query";
        headers[4] = "Authorization";
        headers[5] = Objects.requireNonNull(authHeader);
        if (userAgent != null) {
            headers[6] = "User-Agent";
            headers[7] = userAgent;
        }
        return headers;
    }

    URI queryUrl(String databaseName) {
        return URI.create("%s/db/%s/query/v2".formatted(this.baseUri, databaseName)).normalize();
    }

    URI txUrl(String databaseName) {
        return URI.create("%s/tx".formatted(this.queryUrl(databaseName)));
    }

    URI txUrl(TransactionInfo tx) {
        return URI.create("%s/%s".formatted(this.txUrl(tx.databaseName()), tx.id()));
    }

    URI commitUrl(TransactionInfo tx) {
        return URI.create("%s/commit".formatted(this.txUrl(tx)));
    }
}

