/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.message.DiscardMessage;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.DiscardSummaryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.MessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.Query;

final class DiscardMessageHandler
implements MessageHandler<Void> {
    private final System.Logger log;
    private final ResponseHandler handler;
    private final DiscardMessage message;
    private final Function<Long, Query> queryFinder;
    private final Consumer<Long> queryDeleteConsumer;

    DiscardMessageHandler(ResponseHandler handler, DiscardMessage message, Function<Long, Query> queryFinder, Consumer<Long> queryDeleteConsumer, LoggingProvider logging) {
        this.log = logging.getLog(this.getClass());
        this.handler = Objects.requireNonNull(handler);
        this.message = Objects.requireNonNull(message);
        this.queryFinder = Objects.requireNonNull(queryFinder);
        this.queryDeleteConsumer = Objects.requireNonNull(queryDeleteConsumer);
    }

    @Override
    public CompletionStage<Void> exchange() {
        return CompletableFuture.completedStage(null).thenApply(ignored -> {
            Query query = this.queryFinder.apply(this.message.qid());
            this.queryDeleteConsumer.accept(query.id());
            this.queryDeleteConsumer.accept(-1L);
            this.handler.onDiscardSummary(new DiscardSummaryImpl(query.metadata()));
            return null;
        });
    }
}

