/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltUnsupportedFeatureException;
import org.neo4j.jdbc.internal.shaded.bolt.values.Point;
import org.neo4j.jdbc.internal.shaded.bolt.values.Type;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

enum CypherTypes {
    Null(Type.NULL, (v, i) -> v.value((Object)null), i -> null),
    List(Type.LIST, null, v -> v.boltValues()),
    Map(Type.MAP, null, Value::asBoltMap),
    Boolean(Type.BOOLEAN, (v, i) -> v.value(java.lang.Boolean.parseBoolean(i)), Value::asBoolean),
    Integer(Type.INTEGER, (v, i) -> v.value(Long.parseLong(i)), Value::asLong),
    Float(Type.FLOAT, (v, i) -> v.value(Double.parseDouble(i)), Value::asDouble),
    String(Type.STRING, ValueFactory::value, Value::asString),
    Base64(Type.BYTES, (v, i) -> v.value(java.util.Base64.getDecoder().decode((String)i)), v -> java.util.Base64.getEncoder().encodeToString(v.asByteArray())),
    Date(Type.DATE, (v, i) -> v.value(LocalDate.parse(i, DateTimeFormatter.ISO_LOCAL_DATE)), v -> DateTimeFormatter.ISO_LOCAL_DATE.format(v.asLocalDate())),
    Time(Type.TIME, (v, i) -> v.value(OffsetTime.parse(i, DateTimeFormatter.ISO_OFFSET_TIME)), v -> DateTimeFormatter.ISO_OFFSET_TIME.format(v.asOffsetTime())),
    LocalTime(Type.LOCAL_TIME, (v, i) -> v.value(java.time.LocalTime.parse(i, DateTimeFormatter.ISO_LOCAL_TIME)), v -> DateTimeFormatter.ISO_LOCAL_TIME.format(v.asLocalTime())),
    DateTime(Type.DATE_TIME, (v, i) -> v.value(java.time.ZonedDateTime.parse(i, DateTimeFormatter.ISO_ZONED_DATE_TIME)), v -> DateTimeFormatter.ISO_ZONED_DATE_TIME.format(v.asZonedDateTime())),
    OffsetDateTime(Type.DATE_TIME, (v, i) -> v.value(java.time.OffsetDateTime.parse(i, DateTimeFormatter.ISO_OFFSET_DATE_TIME)), v -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(v.asZonedDateTime())),
    ZonedDateTime(Type.DATE_TIME, (v, i) -> v.value(java.time.ZonedDateTime.parse(i, DateTimeFormatter.ISO_ZONED_DATE_TIME)), v -> DateTimeFormatter.ISO_ZONED_DATE_TIME.format(v.asZonedDateTime())),
    LocalDateTime(Type.LOCAL_DATE_TIME, (v, i) -> v.value(java.time.LocalDateTime.parse(i, DateTimeFormatter.ISO_LOCAL_DATE_TIME)), v -> DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(v.asLocalDateTime())),
    Duration(Type.DURATION, CypherTypes::parseDuration, v -> v.asBoltIsoDuration().toString()),
    Point(Type.POINT, CypherTypes::parsePoint, CypherTypes::writePoint),
    Node(Type.NODE, null, CypherTypes::unsupported),
    Relationship(Type.RELATIONSHIP, null, CypherTypes::unsupported),
    Path(Type.PATH, null, CypherTypes::unsupported),
    Vector(Type.VECTOR, null, CypherTypes::unsupportedVector);

    private final BiFunction<ValueFactory, String, Value> reader;
    private final Function<Value, Object> writer;
    private final Type type;
    private static final Pattern WKT_PATTERN;

    private CypherTypes(Type type, BiFunction<ValueFactory, String, Value> reader, Function<Value, Object> writer) {
        this.type = type;
        this.reader = reader;
        this.writer = writer;
    }

    public static CypherTypes typeFromValue(Value value) {
        Type valueType = value.boltValueType();
        for (CypherTypes cypherType : CypherTypes.values()) {
            if (cypherType.type != valueType) continue;
            return cypherType;
        }
        throw new IllegalArgumentException("no Cypher type found representing " + java.lang.String.valueOf((Object)value.boltValueType()));
    }

    public BiFunction<ValueFactory, String, Value> getReader() {
        return this.reader;
    }

    public Function<Value, Object> getWriter() {
        return this.writer;
    }

    private static Value parsePoint(ValueFactory valueFactory, String input) {
        Matcher matcher = WKT_PATTERN.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Illegal pattern");
        }
        int srid = java.lang.Integer.parseInt(matcher.group(1));
        double x = Double.parseDouble(matcher.group(2));
        double y = Double.parseDouble(matcher.group(3));
        String z = matcher.group(4);
        if (z != null && !z.trim().isEmpty()) {
            return valueFactory.point(srid, x, y, Double.parseDouble(z));
        }
        return valueFactory.point(srid, x, y);
    }

    private static String writePoint(Value value) {
        if (value.boltValueType() == Type.POINT) {
            Point point = value.asBoltPoint();
            int srid = point.srid();
            String pointArguments = Double.isNaN(point.z()) ? java.lang.String.format(Locale.US, "%f %f", point.x(), point.y()) : java.lang.String.format(Locale.US, "%f %f %f", point.x(), point.y(), point.z());
            return "SRID=%d;POINT (%s)".formatted(srid, pointArguments);
        }
        throw new IllegalArgumentException("Not a point to convert");
    }

    private static Object unsupported(Value value) {
        throw new IllegalArgumentException("Node value type is not supported");
    }

    private static Object unsupportedVector(Value value) {
        throw new BoltUnsupportedFeatureException("Vector type is not supported");
    }

    private static Value parseDuration(ValueFactory valueFactory, String input) {
        String[] parts = input.split("T", 2);
        long months = 0L;
        long days = 0L;
        long seconds = 0L;
        int nanos = 0;
        if (parts.length == 2) {
            try {
                Period period = Period.parse(parts[0]);
                months = period.getMonths();
                days = period.getDays();
            }
            catch (DateTimeParseException period) {
                // empty catch block
            }
            try {
                Duration duration = java.time.Duration.parse("PT" + parts[1]);
                seconds = duration.getSeconds();
                nanos = duration.getNano();
            }
            catch (DateTimeParseException duration) {}
        } else if (parts.length == 1 && input.startsWith("P") && !input.contains("T")) {
            try {
                Period period = Period.parse(parts[0]);
                int yearsInMonths = period.getYears() * 12;
                months = period.getMonths() + yearsInMonths;
                days = period.getDays();
            }
            catch (DateTimeParseException e) {
                Duration duration = java.time.Duration.parse(parts[0]);
                seconds = duration.getSeconds();
                nanos = duration.getNano();
            }
        }
        return valueFactory.isoDuration(months, days, seconds, nanos);
    }

    static {
        WKT_PATTERN = Pattern.compile("SRID=(\\d+);\\s*POINT\\s?Z?\\s?\\(\\s*(\\S+)\\s+(\\S+)\\s*(\\S*)\\)");
    }
}

