/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.AbstractMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.CommitSummaryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.HttpContext;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.TransactionInfo;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

final class CommitMessageHandler
extends AbstractMessageHandler<Void> {
    private final System.Logger log;
    private final ResponseHandler handler;
    private final HttpContext httpContext;
    private final Supplier<String> authHeaderSupplier;
    private final Supplier<TransactionInfo> transactionInfoSupplier;
    private final Duration readTimeout;

    CommitMessageHandler(ResponseHandler handler, HttpContext httpContext, Supplier<String> authHeaderSupplier, Supplier<TransactionInfo> transactionInfoSupplier, Duration readTimeout, ValueFactory valueFactory, LoggingProvider logging) {
        super(httpContext, handler, valueFactory, logging);
        this.log = logging.getLog(this.getClass());
        this.handler = Objects.requireNonNull(handler);
        this.httpContext = Objects.requireNonNull(httpContext);
        this.authHeaderSupplier = Objects.requireNonNull(authHeaderSupplier);
        this.transactionInfoSupplier = Objects.requireNonNull(transactionInfoSupplier);
        this.readTimeout = readTimeout;
    }

    @Override
    protected HttpRequest newHttpRequest() {
        TransactionInfo transactionInfo = this.transactionInfoSupplier.get();
        if (transactionInfo == null) {
            throw new BoltClientException("No transaction found");
        }
        String[] headers = this.httpContext.headers(this.authHeaderSupplier.get());
        if (transactionInfo.affinity() != null) {
            headers = Arrays.copyOf(headers, headers.length + 2);
            headers[headers.length - 2] = "neo4j-cluster-affinity";
            headers[headers.length - 1] = transactionInfo.affinity();
        }
        URI uri = this.httpContext.commitUrl(transactionInfo);
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).headers(headers).POST(HttpRequest.BodyPublishers.noBody());
        if (this.readTimeout != null) {
            builder = builder.timeout(this.readTimeout);
        }
        return builder.build();
    }

    @Override
    protected Void handleResponse(HttpResponse<String> response) {
        try {
            BookmarksWrapper bookmarksWrapper = this.httpContext.json().beanFrom(BookmarksWrapper.class, response.body());
            List<String> bookmarks = bookmarksWrapper.bookmarks();
            String bookmark = null;
            if (bookmarks == null) {
                this.log.log(System.Logger.Level.INFO, "No bookmarks found");
            } else if (bookmarks.isEmpty()) {
                this.log.log(System.Logger.Level.INFO, "No bookmarks found");
            } else if (bookmarks.size() > 1) {
                this.log.log(System.Logger.Level.INFO, "Multiple bookmarks found");
                bookmark = bookmarks.get(0);
            } else {
                bookmark = bookmarks.get(0);
            }
            this.handler.onCommitSummary(new CommitSummaryImpl(bookmark));
            return null;
        }
        catch (IOException e) {
            throw new BoltClientException("Cannot parse %s to BookmarksWrapper".formatted(response.body()), e);
        }
    }

    record BookmarksWrapper(List<String> bookmarks) {
    }
}

