/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.neo4j.jdbc.internal.shaded.bolt.GqlStatusError;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltConnectionReadTimeoutException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltFailureException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltServiceUnavailableException;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.Error;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.ErrorsData;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.FutureUtil;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.HttpContext;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.HttpUtil;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.MessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSON;

abstract class AbstractMessageHandler<T>
implements MessageHandler<T> {
    private final System.Logger log;
    private final HttpClient httpClient;
    private final JSON json;
    protected final ResponseHandler handler;
    protected final ValueFactory valueFactory;

    AbstractMessageHandler(HttpContext httpContext, ResponseHandler handler, ValueFactory valueFactory, LoggingProvider logging) {
        this.log = logging.getLog(this.getClass());
        this.httpClient = Objects.requireNonNull(httpContext.httpClient());
        this.json = Objects.requireNonNull(httpContext.json());
        this.handler = Objects.requireNonNull(handler);
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public CompletionStage<T> exchange() {
        HttpRequest request = this.newHttpRequest();
        this.log.log(System.Logger.Level.DEBUG, "Sending request %s".formatted(HttpUtil.mapToString(request)));
        return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).handle((response, throwable) -> {
            if (throwable != null) {
                this.log.log(System.Logger.Level.DEBUG, "An error occurred while sending request %s".formatted(throwable.getMessage()));
                throwable = FutureUtil.completionExceptionCause(throwable);
                if (throwable instanceof HttpTimeoutException) {
                    throw new BoltConnectionReadTimeoutException("Read timedout has been exceeded", (Throwable)throwable);
                }
                if (!(throwable instanceof IOException)) throw new BoltException("An error occurred while sending request", (Throwable)throwable);
                throw new BoltServiceUnavailableException("An error occurred while sending request", (Throwable)throwable);
            }
            this.log.log(System.Logger.Level.DEBUG, "Received response %s".formatted(HttpUtil.mapToString(response)));
            switch (response.statusCode()) {
                case 200: 
                case 202: {
                    T t5;
                    String body = (String)response.body();
                    try {
                        if (body == null || body.isEmpty()) {
                            T t2 = this.handleResponse((HttpResponse<String>)response);
                            t5 = t2;
                            return t5;
                        }
                        Map<String, Object> jsonObject = this.json.mapFrom(body);
                        if (jsonObject != null && jsonObject.get("errors") != null) {
                            T t3;
                            t5 = t3 = this.handleFailureResponse((HttpResponse<String>)response);
                            return t5;
                        }
                        T t4 = this.handleResponse((HttpResponse<String>)response);
                        t5 = t4;
                        return t5;
                    }
                    catch (IOException e) {
                        throw new BoltClientException("Cannot parse response %s".formatted(body), e);
                    }
                }
                case 400: 
                case 401: 
                case 404: 
                case 500: {
                    T t;
                    T t5 = t = this.handleFailureResponse((HttpResponse<String>)response);
                    return t5;
                }
            }
            throw new BoltException("An unexpected response code: " + response.statusCode(), null);
        });
    }

    protected abstract HttpRequest newHttpRequest();

    protected abstract T handleResponse(HttpResponse<String> var1);

    protected T handleFailureResponse(HttpResponse<String> response) {
        try {
            ErrorsData errorsData = this.json.beanFrom(ErrorsData.class, response.body());
            Error error = errorsData.errors().get(0);
            Map<String, Value> diagnosticRecord = Map.ofEntries(Map.entry("CURRENT_SCHEMA", this.valueFactory.value("/")), Map.entry("OPERATION", this.valueFactory.value("")), Map.entry("OPERATION_CODE", this.valueFactory.value("0")));
            throw new BoltFailureException(error.code(), error.message(), GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(error.message()), diagnosticRecord, null);
        }
        catch (IOException e) {
            throw new BoltClientException("Cannot parse %s to ErrorsData".formatted(response.body()), e);
        }
    }
}

