/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.values.Type;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;

public class CommitTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<String> commitFuture;

    public CommitTxResponseHandler(CompletableFuture<String> commitFuture) {
        this.commitFuture = Objects.requireNonNull(commitFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        Value bookmarkValue = metadata.get("bookmark");
        String bookmark = null;
        if (bookmarkValue != null && !bookmarkValue.isNull() && Type.STRING.equals((Object)bookmarkValue.boltValueType()) && (bookmark = bookmarkValue.asString()).isEmpty()) {
            bookmark = null;
        }
        this.commitFuture.complete(bookmark);
    }

    @Override
    public void onFailure(Throwable error) {
        this.commitFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(List<Value> fields) {
        throw new UnsupportedOperationException("Transaction commit is not expected to receive records: " + String.valueOf(fields));
    }
}

