/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import java.time.Clock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.InboundMessageDispatcher;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.jdbc.internal.shaded.io.netty.handler.ssl.SslHandler;

public class NettyChannelInitializer
extends ChannelInitializer<Channel> {
    private final BoltServerAddress address;
    private final SecurityPlan securityPlan;
    private final int connectTimeoutMillis;
    private final Clock clock;
    private final LoggingProvider logging;

    public NettyChannelInitializer(BoltServerAddress address, SecurityPlan securityPlan, int connectTimeoutMillis, Clock clock, LoggingProvider logging) {
        this.address = address;
        this.securityPlan = securityPlan;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.clock = clock;
        this.logging = logging;
    }

    @Override
    protected void initChannel(Channel channel) {
        if (this.securityPlan != null) {
            SslHandler sslHandler = this.createSslHandler();
            channel.pipeline().addFirst(sslHandler);
        }
        this.updateChannelAttributes(channel);
    }

    private SslHandler createSslHandler() {
        SSLEngine sslEngine = this.createSslEngine();
        SslHandler sslHandler = new SslHandler(sslEngine);
        sslHandler.setHandshakeTimeoutMillis(this.connectTimeoutMillis);
        return sslHandler;
    }

    private SSLEngine createSslEngine() {
        SSLContext sslContext = this.securityPlan.sslContext();
        String host = this.securityPlan.expectedHostname();
        if (host == null) {
            host = this.address.host();
        }
        SSLEngine sslEngine = sslContext.createSSLEngine(host, this.address.port());
        sslEngine.setUseClientMode(true);
        if (this.securityPlan.verifyHostname()) {
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        }
        return sslEngine;
    }

    private void updateChannelAttributes(Channel channel) {
        ChannelAttributes.setServerAddress(channel, this.address);
        ChannelAttributes.setCreationTimestamp(channel, this.clock.millis());
        ChannelAttributes.setMessageDispatcher(channel, new InboundMessageDispatcher(channel, this.logging));
    }
}

