/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl;

import java.util.regex.Pattern;
import org.neo4j.jdbc.internal.shaded.io.netty.util.internal.logging.AbstractInternalLogger;

public class NettyLogger
extends AbstractInternalLogger {
    private static final long serialVersionUID = -1466889786216191159L;
    private final System.Logger log;
    private static final Pattern PLACE_HOLDER_PATTERN = Pattern.compile("\\{}");

    public NettyLogger(String name, System.Logger log) {
        super(name);
        this.log = log;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isLoggable(System.Logger.Level.TRACE);
    }

    @Override
    public void trace(String msg) {
        this.log.log(System.Logger.Level.TRACE, msg);
    }

    @Override
    public void trace(String format, Object arg) {
        this.log.log(System.Logger.Level.TRACE, this.toDriverLoggerFormat(format), arg);
    }

    @Override
    public void trace(String format, Object argA, Object argB) {
        this.log.log(System.Logger.Level.TRACE, this.toDriverLoggerFormat(format), argA, argB);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log.log(System.Logger.Level.TRACE, this.toDriverLoggerFormat(format), arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log.log(System.Logger.Level.TRACE, "%s%n%s", msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(System.Logger.Level.DEBUG);
    }

    @Override
    public void debug(String msg) {
        this.log.log(System.Logger.Level.DEBUG, msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.log.log(System.Logger.Level.DEBUG, this.toDriverLoggerFormat(format), arg);
    }

    @Override
    public void debug(String format, Object argA, Object argB) {
        this.log.log(System.Logger.Level.DEBUG, this.toDriverLoggerFormat(format), argA, argB);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log.log(System.Logger.Level.DEBUG, this.toDriverLoggerFormat(format), arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log.log(System.Logger.Level.DEBUG, "%s%n%s", msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return true;
    }

    @Override
    public void info(String msg) {
        this.log.log(System.Logger.Level.INFO, msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.log.log(System.Logger.Level.INFO, this.toDriverLoggerFormat(format), arg);
    }

    @Override
    public void info(String format, Object argA, Object argB) {
        this.log.log(System.Logger.Level.INFO, this.toDriverLoggerFormat(format), argA, argB);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log.log(System.Logger.Level.INFO, this.toDriverLoggerFormat(format), arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log.log(System.Logger.Level.INFO, "%s%n%s", msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void warn(String msg) {
        this.log.log(System.Logger.Level.WARNING, msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.log.log(System.Logger.Level.WARNING, this.toDriverLoggerFormat(format), arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log.log(System.Logger.Level.WARNING, this.toDriverLoggerFormat(format), arguments);
    }

    @Override
    public void warn(String format, Object argA, Object argB) {
        this.log.log(System.Logger.Level.WARNING, this.toDriverLoggerFormat(format), argA, argB);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log.log(System.Logger.Level.WARNING, "%s%n%s", msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public void error(String msg) {
        this.log.log(System.Logger.Level.ERROR, msg, (Throwable)null);
    }

    @Override
    public void error(String format, Object arg) {
        this.error(format, new Object[]{arg});
    }

    @Override
    public void error(String format, Object argA, Object argB) {
        this.error(format, new Object[]{argA, argB});
    }

    @Override
    public void error(String format, Object ... arguments) {
        format = this.toDriverLoggerFormat(format);
        if (arguments.length == 0) {
            this.log.log(System.Logger.Level.ERROR, format, (Throwable)null);
            return;
        }
        Object arg = arguments[arguments.length - 1];
        if (arg instanceof Throwable) {
            this.log.log(System.Logger.Level.ERROR, String.format(format, arguments), (Throwable)arg);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log.log(System.Logger.Level.ERROR, msg, t);
    }

    private String toDriverLoggerFormat(String format) {
        return PLACE_HOLDER_PATTERN.matcher(format).replaceAll("%s");
    }
}

