/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl;

import java.net.URI;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.BoltAgent;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnection;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.DomainNameResolver;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.MetricsListener;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.MinVersionAcquisitionException;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.BoltConnectionImpl;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.ConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.ConnectionProviders;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.NettyLogging;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.NoopMetricsListener;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.RoutingContext;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.Scheme;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.Connection;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.util.FutureUtil;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.jdbc.internal.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public final class NettyBoltConnectionProvider
implements BoltConnectionProvider {
    private final LoggingProvider logging;
    private final System.Logger log;
    private final EventLoopGroup eventLoopGroup;
    private final ConnectionProvider connectionProvider;
    private final MetricsListener metricsListener;
    private final Clock clock;
    private final ValueFactory valueFactory;
    private final boolean shutdownEventLoopGroupOnClose;
    private CompletableFuture<Void> closeFuture;

    public NettyBoltConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, DomainNameResolver domainNameResolver, LocalAddress localAddress, BoltProtocolVersion maxVersion, LoggingProvider logging, ValueFactory valueFactory, MetricsListener metricsListener, boolean shutdownEventLoopGroupOnClose) {
        Objects.requireNonNull(eventLoopGroup);
        this.clock = Objects.requireNonNull(clock);
        this.logging = Objects.requireNonNull(logging);
        this.log = logging.getLog(this.getClass());
        this.eventLoopGroup = Objects.requireNonNull(eventLoopGroup);
        this.connectionProvider = ConnectionProviders.netty(eventLoopGroup, clock, domainNameResolver, localAddress, maxVersion, logging, valueFactory);
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.metricsListener = NoopMetricsListener.getInstance();
        InternalLoggerFactory.setDefaultFactory(new NettyLogging(logging));
        this.shutdownEventLoopGroupOnClose = shutdownEventLoopGroupOnClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<BoltConnection> connect(URI uri, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        RoutingContext routingContext;
        BoltServerAddress uriAddress;
        NettyBoltConnectionProvider nettyBoltConnectionProvider = this;
        synchronized (nettyBoltConnectionProvider) {
            if (this.closeFuture != null) {
                return CompletableFuture.failedFuture(new IllegalStateException("Connection provider is closed."));
            }
        }
        try {
            uriAddress = new BoltServerAddress(uri);
        }
        catch (Throwable throwable2) {
            return CompletableFuture.failedStage(new BoltClientException("Failed to parse server address: " + String.valueOf(uri), throwable2));
        }
        BoltServerAddress address = securityPlan != null && securityPlan.expectedHostname() != null ? new BoltServerAddress(securityPlan.expectedHostname(), uriAddress.connectionHost(), uriAddress.port()) : uriAddress;
        try {
            routingContext = new RoutingContext(uri, routingContextAddress);
        }
        catch (Exception e) {
            return CompletableFuture.failedStage(e);
        }
        if (!Scheme.isRoutingScheme(uri.getScheme()) && routingContext.isDefined()) {
            return CompletableFuture.failedStage(new IllegalArgumentException("%s scheme must not contain routing context".formatted(uri.getScheme())));
        }
        CompletableFuture<Long> latestAuthMillisFuture = new CompletableFuture<Long>();
        return this.connectionProvider.acquireConnection(address, securityPlan, routingContext, authToken.asMap(), boltAgent, userAgent, connectTimeoutMillis, latestAuthMillisFuture, notificationConfig, this.metricsListener).thenCompose(connection -> {
            if (minVersion != null && minVersion.compareTo(connection.protocol().version()) > 0) {
                return connection.close().thenCompose(ignored -> CompletableFuture.failedStage(new MinVersionAcquisitionException("lower version", connection.protocol().version())));
            }
            return CompletableFuture.completedStage(connection);
        }).handle((connection, throwable) -> {
            if (throwable != null) {
                throwable = FutureUtil.completionExceptionCause(throwable);
                this.log.log(System.Logger.Level.DEBUG, "Failed to establish BoltConnection " + String.valueOf(address), (Throwable)throwable);
                throw new CompletionException((Throwable)throwable);
            }
            return new BoltConnectionImpl(connection.protocol(), (Connection)connection, connection.eventLoop(), authToken, latestAuthMillisFuture, routingContext, this.clock, this.logging, this.valueFactory);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture;
        NettyBoltConnectionProvider nettyBoltConnectionProvider = this;
        synchronized (nettyBoltConnectionProvider) {
            if (this.closeFuture == null) {
                this.closeFuture = new CompletableFuture();
                if (this.shutdownEventLoopGroupOnClose) {
                    this.eventLoopGroup.shutdownGracefully(200L, 15000L, TimeUnit.MILLISECONDS).addListener(future -> this.closeFuture.complete(null));
                } else {
                    this.closeFuture.complete(null);
                }
            }
            closeFuture = this.closeFuture;
        }
        return closeFuture;
    }
}

