/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt;

import java.util.Set;
import java.util.function.Consumer;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionParameters;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseName;
import org.neo4j.jdbc.internal.shaded.bolt.RoutedBoltConnectionParametersImpl;
import org.neo4j.jdbc.internal.shaded.bolt.RoutingParametersBuilderImpl;

public interface RoutedBoltConnectionParameters
extends BoltConnectionParameters {
    public AccessMode accessMode();

    public DatabaseName databaseName();

    public Consumer<DatabaseName> databaseNameListener();

    public String homeDatabaseHint();

    public Set<String> bookmarks();

    public String impersonatedUser();

    public static RoutedBoltConnectionParameters defaultParameters() {
        return RoutedBoltConnectionParametersImpl.DEFAULT;
    }

    public static Builder builder() {
        return new RoutingParametersBuilderImpl();
    }

    public static interface Builder
    extends BoltConnectionParameters.Builder {
        @Override
        public Builder withAuthToken(AuthToken var1);

        @Override
        public Builder withMinVersion(BoltProtocolVersion var1);

        public Builder withAccessMode(AccessMode var1);

        public Builder withDatabaseName(DatabaseName var1);

        public Builder withDatabaseNameListener(Consumer<DatabaseName> var1);

        public Builder withHomeDatabaseHint(String var1);

        public Builder withBookmarks(Set<String> var1);

        public Builder withImpersonatedUser(String var1);

        @Override
        public RoutedBoltConnectionParameters build();
    }
}

