/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.util.Iterator;
import java.util.List;
import org.neo4j.jdbc.internal.shaded.bolt.values.Path;
import org.neo4j.jdbc.values.Node;
import org.neo4j.jdbc.values.Path;
import org.neo4j.jdbc.values.Relationship;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

final class PathImpl
implements org.neo4j.jdbc.values.Path,
Path {
    private final List<Node> nodes;
    private final List<Relationship> relationships;
    private final List<Path.Segment> segments;

    PathImpl(List<Path.Segment> segments, List<Node> nodes, List<Relationship> relationships) {
        this.segments = segments;
        this.nodes = nodes;
        this.relationships = relationships;
    }

    @Override
    public int length() {
        return this.relationships.size();
    }

    @Override
    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.relationships.contains(relationship);
    }

    @Override
    public Iterable<Node> nodes() {
        return this.nodes;
    }

    @Override
    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    @Override
    public Node start() {
        return this.nodes.get(0);
    }

    @Override
    public Node end() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        return this.segments.iterator();
    }

    @Override
    public Value asValue() {
        return Values.value((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathImpl segments1 = (PathImpl)o;
        return this.segments.equals(segments1.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return "path" + String.valueOf(this.segments);
    }
}

