/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.neo4j.jdbc.Bookmark;
import org.neo4j.jdbc.BookmarkManager;
import org.neo4j.jdbc.ConnectionImpl;
import org.neo4j.jdbc.DefaultBookmarkManagerImpl;
import org.neo4j.jdbc.Events;
import org.neo4j.jdbc.Lazy;
import org.neo4j.jdbc.MetricsCollector;
import org.neo4j.jdbc.Neo4jDriverExtensions;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.NoopBookmarkManagerImpl;
import org.neo4j.jdbc.ProductVersion;
import org.neo4j.jdbc.Tracing;
import org.neo4j.jdbc.TranslatorComparator;
import org.neo4j.jdbc.authn.spi.Authentication;
import org.neo4j.jdbc.authn.spi.AuthenticationSupplierFactory;
import org.neo4j.jdbc.authn.spi.CustomAuthentication;
import org.neo4j.jdbc.authn.spi.DisabledAuthentication;
import org.neo4j.jdbc.authn.spi.TokenAuthentication;
import org.neo4j.jdbc.authn.spi.UsernamePasswordAuthentication;
import org.neo4j.jdbc.events.ConnectionListener;
import org.neo4j.jdbc.events.DriverListener;
import org.neo4j.jdbc.internal.bolt.BoltAdapters;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.AuthTokens;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnection;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionProvider;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionProviderFactory;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlans;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.dotenv.Dotenv;
import org.neo4j.jdbc.internal.shaded.dotenv.DotenvBuilder;
import org.neo4j.jdbc.tracing.Neo4jTracer;
import org.neo4j.jdbc.translator.spi.Translator;
import org.neo4j.jdbc.translator.spi.TranslatorFactory;

public final class Neo4jDriver
implements Neo4jDriverExtensions {
    public static final String PROPERTY_HOST = "host";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_DATABASE = "database";
    public static final String PROPERTY_USER_AGENT = "agent";
    public static final String USER_AGENT_ENV_KEY = "NEO4J_JDBC_USER_AGENT";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_AUTH_SCHEME = "authScheme";
    public static final String PROPERTY_AUTH_REALM = "authRealm";
    public static final String PROPERTY_AUTHN_SUPPLIER = "authn.supplier";
    public static final String PROPERTY_TIMEOUT = "timeout";
    public static final String PROPERTY_SQL_TRANSLATION_ENABLED = "enableSQLTranslation";
    public static final String PROPERTY_USE_BOOKMARKS = "useBookmarks";
    public static final String PROPERTY_REWRITE_PLACEHOLDERS = "rewritePlaceholders";
    public static final String PROPERTY_SQL_TRANSLATION_CACHING_ENABLED = "cacheSQLTranslations";
    public static final String PROPERTY_TRANSLATOR_FACTORY = "translatorFactory";
    public static final String PROPERTY_REWRITE_BATCHED_STATEMENTS = "rewriteBatchedStatements";
    public static final String PROPERTY_SSL = "ssl";
    public static final String PROPERTY_RELATIONSHIP_SAMPLE_SIZE = "relationshipSampleSize";
    public static final String PROPERTY_SSL_MODE = "sslMode";
    private static final String URL_REGEX = "^jdbc:neo4j(?:\\+(?<transport>s(?:sc)?)?)?(?::(?<protocol>https?))?://(?<host>[^:/?]+):?(?<port>\\d+)?/?(?<database>[^?]+)?\\??(?<urlParams>\\S+)?$";
    public static final Pattern URL_PATTERN = Pattern.compile("^jdbc:neo4j(?:\\+(?<transport>s(?:sc)?)?)?(?::(?<protocol>https?))?://(?<host>[^:/?]+):?(?<port>\\d+)?/?(?<database>[^?]+)?\\??(?<urlParams>\\S+)?$");
    private static final BoltProtocolVersion MIN_BOLT_VERSION = new BoltProtocolVersion(5, 1);
    private static final Map<String, Object> BOLT_CONNECTION_OPTIONS = Map.of("eventLoopThreadNamePrefix", "Neo4jJDBCDriverIO", "maxVersion", new BoltProtocolVersion(5, 8));
    private final List<BoltConnectionProviderFactory> boltConnectionProviderFactories;
    private final Map<String, BoltConnectionProvider> providerCache = new ConcurrentHashMap<String, BoltConnectionProvider>();
    private final Lazy<List<TranslatorFactory>> sqlTranslatorFactories = Lazy.of(() -> this.loadServices(TranslatorFactory.class));
    private final Lazy<Map<String, AuthenticationSupplierFactory>> authenticationSupplierFactories = Lazy.of(() -> this.loadServices(AuthenticationSupplierFactory.class).stream().collect(Collectors.collectingAndThen(Collectors.toMap(AuthenticationSupplierFactory::getName, Function.identity()), Map::copyOf)));
    private final Map<DriverConfig, BookmarkManager> bookmarkManagers = new ConcurrentHashMap<DriverConfig, BookmarkManager>();
    private final Map<String, Object> transactionMetadata = new ConcurrentHashMap<String, Object>();
    private final Set<DriverListener> listeners = new HashSet<DriverListener>();
    private Neo4jTracer tracer;
    private Supplier<Authentication> authenticationSupplier;

    @Deprecated(since="6.6.0")
    public static SpecifyAdditionalPropertiesStep withSQLTranslation() {
        return new SpecifyAdditionalPropertiesOrAuthStepImpl(new BuilderImpl(true, Map.of(), null));
    }

    @Deprecated(since="6.6.0")
    public static SpecifyTranslationStep withProperties(Map<String, Object> additionalProperties) {
        return new SpecifyTranslationOrAuthStepImpl(new BuilderImpl(false, additionalProperties, null));
    }

    public static void registerAuthenticationSupplier(Supplier<Authentication> authenticationSupplier) {
        Neo4jDriver.iterateGlobalNeo4jDrivers(driver -> driver.setAuthenticationSupplier(authenticationSupplier));
    }

    public static void registerTracer(Neo4jTracer tracer) {
        Neo4jDriver.iterateGlobalNeo4jDrivers(driver -> driver.setTracer(tracer));
    }

    private static void iterateGlobalNeo4jDrivers(Consumer<Neo4jDriver> callback) {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!(driver instanceof Neo4jDriver)) continue;
            Neo4jDriver neo4jDriver = (Neo4jDriver)driver;
            callback.accept(neo4jDriver);
        }
    }

    public static SpecifyAdditionalPropertiesOrTranslationStep withAuthenticationSupplier(Supplier<Authentication> authenticationSupplier) {
        return new SpecifyAdditionalPropertiesOrTranslationStepImpl(new BuilderImpl(false, Map.of(), authenticationSupplier));
    }

    public static Optional<Connection> fromEnv() throws SQLException {
        return Neo4jDriver.fromEnv(null, null);
    }

    public static Optional<Connection> fromEnv(Path directory) throws SQLException {
        return Neo4jDriver.fromEnv(directory, null);
    }

    public static Optional<Connection> fromEnv(String filename) throws SQLException {
        return Neo4jDriver.fromEnv(null, filename);
    }

    public static Optional<Connection> fromEnv(Path directory, String filename) throws SQLException {
        return new BuilderImpl(false, Map.of(), null).fromEnv(directory, filename);
    }

    public Neo4jDriver() {
        this(List.of());
    }

    Neo4jDriver(List<BoltConnectionProviderFactory> boltConnectionProviderFactories) {
        this.boltConnectionProviderFactories = boltConnectionProviderFactories.isEmpty() ? this.loadServices(BoltConnectionProviderFactory.class) : List.copyOf(boltConnectionProviderFactories);
        MetricsCollector.tryGlobal().ifPresent(this::addListener);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.connect(url, info, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info, Supplier<Authentication> authenticationSupplier) throws SQLException {
        DriverConfig driverConfig = DriverConfig.of(url, info);
        SecurityPlan securityPlan = Neo4jDriver.parseSSLParams(driverConfig.sslProperties);
        String databaseName = driverConfig.database;
        String userAgent = driverConfig.agent;
        int connectTimeoutMillis = driverConfig.timeout;
        boolean enableSqlTranslation = driverConfig.enableSQLTranslation;
        boolean enableTranslationCaching = driverConfig.enableTranslationCaching;
        boolean rewriteBatchedStatements = driverConfig.rewriteBatchedStatements;
        boolean rewritePlaceholders = driverConfig.rewritePlaceholders;
        String translatorFactory = driverConfig.rawConfig.get(PROPERTY_TRANSLATOR_FACTORY);
        BookmarkManager bookmarkManager = this.bookmarkManagers.computeIfAbsent(driverConfig, k -> driverConfig.useBookmarks ? new DefaultBookmarkManagerImpl() : new NoopBookmarkManagerImpl());
        Supplier<List<TranslatorFactory>> translatorFactoriesSupplier = this.sqlTranslatorFactories::resolve;
        if (translatorFactory != null && !translatorFactory.isBlank()) {
            translatorFactoriesSupplier = () -> this.getSqlTranslatorFactory(translatorFactory);
        }
        Supplier<Authentication> finalAuthenticationSupplier = this.determineAuthenticationSupplier(authenticationSupplier, driverConfig);
        URI targetUrl = driverConfig.toUrl();
        ArrayList<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
        this.listeners.forEach(listener -> {
            if (listener instanceof ConnectionListener) {
                ConnectionListener connectionListener = (ConnectionListener)((Object)listener);
                connectionListeners.add(connectionListener);
            }
        });
        ConnectionImpl connection = new ConnectionImpl(targetUrl, finalAuthenticationSupplier, authentication -> this.establishBoltConnection(driverConfig, userAgent, connectTimeoutMillis, securityPlan, Neo4jDriver.toAuthToken(authentication)), Neo4jDriver.getSqlTranslatorSupplier(enableSqlTranslation, driverConfig.rawConfig(), translatorFactoriesSupplier), enableSqlTranslation, enableTranslationCaching, rewriteBatchedStatements, rewritePlaceholders, bookmarkManager, this.transactionMetadata, driverConfig.relationshipSampleSize(), databaseName, aborted -> {
            DriverListener.ConnectionClosedEvent event = new DriverListener.ConnectionClosedEvent(targetUrl, (boolean)aborted);
            Events.notify(this.listeners, listener -> listener.onConnectionClosed(event));
        }, connectionListeners);
        Neo4jDriver neo4jDriver = this;
        synchronized (neo4jDriver) {
            if (this.tracer != null) {
                connection.addListener(new Tracing(this.tracer, connection));
            }
        }
        Events.notify(this.listeners, listener -> listener.onConnectionOpened(new DriverListener.ConnectionOpenedEvent(targetUrl)));
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Supplier<Authentication> determineAuthenticationSupplier(Supplier<Authentication> authenticationSupplier, DriverConfig driverConfig) {
        Object factory;
        String password;
        if (authenticationSupplier != null) {
            return authenticationSupplier;
        }
        String user = driverConfig.user == null || driverConfig.user.isBlank() ? "" : driverConfig.user;
        String string = password = driverConfig.password == null || driverConfig.password.isBlank() ? "" : driverConfig.password;
        if (driverConfig.rawConfig().containsKey(PROPERTY_AUTHN_SUPPLIER) && (factory = this.authenticationSupplierFactories.resolve().get(driverConfig.rawConfig().get(PROPERTY_AUTHN_SUPPLIER))) != null) {
            String prefix = "authn.%s.".formatted(factory.getName().toLowerCase(Locale.ROOT));
            return factory.create(user, password, driverConfig.rawConfig.entrySet().stream().filter(e -> ((String)e.getKey()).toLowerCase(Locale.ROOT).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).replace(prefix, ""), Map.Entry::getValue)));
        }
        factory = this;
        synchronized (factory) {
            if (this.authenticationSupplier != null) {
                return this.authenticationSupplier;
            }
        }
        String authRealm = driverConfig.authRealm == null || driverConfig.authRealm.isBlank() ? null : driverConfig.authRealm;
        Authentication authentication = switch (driverConfig.authScheme) {
            default -> throw new IncompatibleClassChangeError();
            case AuthScheme.NONE -> Authentication.none();
            case AuthScheme.BASIC -> Authentication.usernameAndPassword(user, password, authRealm);
            case AuthScheme.BEARER -> Authentication.bearer(password);
            case AuthScheme.KERBEROS -> Authentication.kerberos(password);
        };
        return () -> authentication;
    }

    static AuthToken toAuthToken(Authentication authentication) {
        ValueFactory valueFactory = BoltAdapters.getValueFactory();
        if (authentication instanceof DisabledAuthentication) {
            return AuthTokens.none(valueFactory);
        }
        if (authentication instanceof UsernamePasswordAuthentication) {
            UsernamePasswordAuthentication usernameAndPassword = (UsernamePasswordAuthentication)authentication;
            return AuthTokens.basic(usernameAndPassword.username(), usernameAndPassword.password(), usernameAndPassword.realm(), valueFactory);
        }
        if (authentication instanceof TokenAuthentication) {
            TokenAuthentication token = (TokenAuthentication)authentication;
            return switch (token.scheme().toLowerCase(Locale.ROOT)) {
                case "bearer" -> AuthTokens.bearer(token.value(), valueFactory);
                case "kerberos" -> AuthTokens.kerberos(token.value(), valueFactory);
                default -> throw new IllegalArgumentException("Invalid scheme `%s` for token based authentication".formatted(token.scheme()));
            };
        }
        if (authentication instanceof CustomAuthentication) {
            CustomAuthentication customAuthentication = (CustomAuthentication)authentication;
            return AuthTokens.custom(BoltAdapters.adaptMap(customAuthentication.toMap()));
        }
        throw new IllegalArgumentException("Unsupported authentication type %s".formatted(authentication));
    }

    private BoltConnection establishBoltConnection(DriverConfig driverConfig, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken) {
        URI targetUri = URI.create("%s://%s%s".formatted(driverConfig.protocol(), driverConfig.host(), driverConfig.formattedPort()));
        BoltConnectionProvider connectionProvider = this.providerCache.computeIfAbsent(targetUri.getScheme(), scheme -> this.boltConnectionProviderFactories.stream().filter(factory -> factory.supports((String)scheme)).findFirst().map(factory -> factory.create(BoltAdapters.newLoggingProvider(), BoltAdapters.getValueFactory(), null, BOLT_CONNECTION_OPTIONS)).orElseThrow(() -> new RuntimeException("Failed to load a connection provider supporting target %s".formatted(targetUri))));
        return connectionProvider.connect(targetUri, null, BoltAdapters.newAgent(ProductVersion.getValue()), userAgent, connectTimeoutMillis, securityPlan, authToken, MIN_BOLT_VERSION, NotificationConfig.defaultConfig()).toCompletableFuture().join();
    }

    static String getDefaultUserAgent() {
        if (System.getProperties().containsKey(USER_AGENT_ENV_KEY) && !System.getProperties().getProperty(USER_AGENT_ENV_KEY).isBlank()) {
            return System.getProperties().getProperty(USER_AGENT_ENV_KEY);
        }
        if (System.getenv().containsKey(USER_AGENT_ENV_KEY) && !System.getenv().get(USER_AGENT_ENV_KEY).isBlank()) {
            return System.getenv().get(USER_AGENT_ENV_KEY);
        }
        return "neo4j-jdbc/%s".formatted(ProductVersion.getValue());
    }

    static Map<String, String> mergeConfig(String[] urlParams, Properties jdbcProperties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : jdbcProperties.stringPropertyNames()) {
            String value = jdbcProperties.getProperty(name);
            if (value == null) continue;
            result.put(name, value);
        }
        String regex = "^(?<name>\\S+)=(?<value>\\S+)$";
        Pattern pattern = Pattern.compile(regex);
        for (String param : urlParams) {
            Matcher matcher = pattern.matcher(param);
            if (!matcher.matches()) continue;
            String name = URLDecoder.decode(matcher.group("name"), StandardCharsets.UTF_8);
            String value = URLDecoder.decode(matcher.group("value"), StandardCharsets.UTF_8);
            result.put(name, value);
        }
        return Map.copyOf(result);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new Neo4jException(Neo4jException.GQLError.$22000.withMessage("url cannot be null"));
        }
        return URL_PATTERN.matcher(url).matches();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        DriverConfig parsedConfig = DriverConfig.of(url, info);
        ArrayList<DriverPropertyInfo> driverPropertyInfos = new ArrayList<DriverPropertyInfo>();
        String[] trueFalseChoices = new String[]{"true", "false"};
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_HOST, parsedConfig.host, "The host name", true, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_PORT, String.valueOf(parsedConfig.port), "The port", true, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_DATABASE, parsedConfig.database, "The database name to connect to. Will default to neo4j if left blank.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_USER, parsedConfig.user, "The user that will be used to connect. Will be defaulted to neo4j if left blank.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_PASSWORD, parsedConfig.password, "The password that is used to connect. Defaults to 'password'.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_AUTH_SCHEME, parsedConfig.authScheme.getName(), "The authentication scheme to use. Defaults to 'basic'.", false, (String[])Arrays.stream(AuthScheme.values()).map(AuthScheme::getName).toArray(String[]::new)));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_AUTH_REALM, parsedConfig.authRealm, "The authentication realm to use. Defaults to ''.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_USER_AGENT, parsedConfig.agent, "User agent to send to server, can be found in logs later.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_TIMEOUT, String.valueOf(parsedConfig.timeout), "Timeout for connection interactions. Defaults to 1000.", false, null));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_SQL_TRANSLATION_ENABLED, String.valueOf(parsedConfig.enableSQLTranslation), "Turns on or of sql to cypher translation. Defaults to false.", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_REWRITE_BATCHED_STATEMENTS, String.valueOf(parsedConfig.rewriteBatchedStatements), "Turns on generation of more efficient cypher when batching statements. Defaults to true.", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_USE_BOOKMARKS, String.valueOf(parsedConfig.useBookmarks), "Enables the use of causal cluster bookmarks. Defaults to true", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_REWRITE_PLACEHOLDERS, String.valueOf(parsedConfig.rewritePlaceholders), "Rewrites SQL placeholders (?) into $1, $2 .. $n. Defaults to true when SQL translation is not enabled.", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_SQL_TRANSLATION_CACHING_ENABLED, String.valueOf(parsedConfig.enableTranslationCaching), "Enable caching of translations.", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_SSL, String.valueOf(parsedConfig.sslProperties.ssl), "SSL enabled", false, trueFalseChoices));
        driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(PROPERTY_SSL_MODE, parsedConfig.sslProperties().sslMode.getName(), "The mode for ssl. Accepted values are: require, verify-full, disable.", false, (String[])Arrays.stream(SSLMode.values()).map(SSLMode::getName).toArray(String[]::new)));
        parsedConfig.misc().forEach((k, v) -> driverPropertyInfos.add(Neo4jDriver.newDriverPropertyInfo(k, v, "", false, null)));
        return (DriverPropertyInfo[])driverPropertyInfos.toArray(DriverPropertyInfo[]::new);
    }

    private static DriverPropertyInfo newDriverPropertyInfo(String name, String value, String description, boolean required, String[] choices) {
        DriverPropertyInfo result = new DriverPropertyInfo(name, value);
        result.description = description;
        result.required = required;
        result.choices = choices;
        return result;
    }

    @Override
    public int getMajorVersion() {
        return ProductVersion.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return ProductVersion.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger(this.getClass().getPackageName());
    }

    private static String[] splitUrlParams(String urlParams) {
        if (urlParams != null) {
            return urlParams.split("&");
        }
        return new String[0];
    }

    private static SecurityPlan parseSSLParams(SSLProperties sslProperties) throws SQLException {
        SecurityPlan securityPlan;
        switch (sslProperties.sslMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case REQUIRE: {
                try {
                    SecurityPlan securityPlan2;
                    securityPlan = securityPlan2 = SecurityPlans.encryptedForAnyCertificate();
                    break;
                }
                catch (GeneralSecurityException ex) {
                    throw new Neo4jException(Neo4jException.withInternal(ex));
                }
            }
            case VERIFY_FULL: {
                try {
                    SecurityPlan securityPlan3;
                    securityPlan = securityPlan3 = SecurityPlans.encryptedForSystemCASignedCertificates();
                    break;
                }
                catch (IOException | GeneralSecurityException ex) {
                    throw new Neo4jException(Neo4jException.withInternal(ex));
                }
            }
            case DISABLE: {
                SecurityPlan securityPlan4;
                securityPlan = securityPlan4 = null;
            }
        }
        return securityPlan;
    }

    private static SSLMode sslMode(String text) throws IllegalArgumentException {
        if (text == null) {
            return null;
        }
        try {
            return SSLMode.valueOf(text.toUpperCase(Locale.ROOT).replace("-", "_"));
        }
        catch (IllegalArgumentException ignored) {
            throw new IllegalArgumentException(String.format("%s is not a valid option for SSLMode", text));
        }
    }

    private static SSLProperties parseSSLProperties(Map<String, String> info, String transport) throws SQLException {
        SSLMode sslMode = Neo4jDriver.sslMode(info.get(PROPERTY_SSL_MODE));
        Boolean ssl = null;
        String sslString = info.get(PROPERTY_SSL);
        if (sslString != null) {
            if (!sslString.equals("true") && !sslString.equals("false")) {
                throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid SSL option, accepts true or false"));
            }
            ssl = Boolean.parseBoolean(sslString);
        }
        if (transport != null) {
            if (transport.equals("s")) {
                if (ssl != null && !ssl.booleanValue()) {
                    throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid transport option +s when ssl option set to false, accepted ssl option is true"));
                }
                ssl = true;
                if (sslMode == null) {
                    sslMode = SSLMode.VERIFY_FULL;
                } else if (sslMode == SSLMode.DISABLE) {
                    throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid SSLMode %s for +s transport option, accepts verify-ca, verify-full, require"));
                }
            } else if (transport.equals("ssc")) {
                if (ssl != null && !ssl.booleanValue()) {
                    throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid transport option +ssc when ssl option set to false, accepted ssl option is true"));
                }
                ssl = true;
                if (sslMode == null) {
                    sslMode = SSLMode.REQUIRE;
                } else if (sslMode != SSLMode.REQUIRE) {
                    throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid SSLMode %s for +scc transport option, accepts 'require' only"));
                }
            } else if (!transport.isEmpty()) {
                throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid Transport section of the URL, accepts +s or +scc"));
            }
        }
        if (ssl == null && (sslMode == SSLMode.VERIFY_FULL || sslMode == SSLMode.REQUIRE)) {
            ssl = true;
        } else if (ssl != null && sslMode == null && ssl.booleanValue()) {
            sslMode = SSLMode.REQUIRE;
        }
        if (sslMode == null) {
            sslMode = SSLMode.DISABLE;
        }
        if (ssl == null) {
            ssl = false;
        }
        if (ssl.booleanValue()) {
            if (sslMode != SSLMode.VERIFY_FULL && sslMode != SSLMode.REQUIRE) {
                throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid sslMode %s when ssl = true, accepts verify-full and require".formatted(new Object[]{sslMode})));
            }
        } else if (sslMode != SSLMode.DISABLE) {
            throw new Neo4jException(Neo4jException.GQLError.$22N11.withMessage("Invalid sslMode %s when ssl = false, accepts disable, allow and prefer".formatted(new Object[]{sslMode})));
        }
        return new SSLProperties(sslMode, ssl);
    }

    private List<TranslatorFactory> getSqlTranslatorFactory(String translatorFactory) {
        String fqn = "DEFAULT".equalsIgnoreCase(translatorFactory) ? "org.neo4j.jdbc.translator.impl.SqlToCypherTranslatorFactory" : translatorFactory;
        try {
            Class<?> cls = Class.forName(fqn);
            return List.of((TranslatorFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException ex) {
            this.getParentLogger().log(Level.WARNING, "Translator factory {0} not found", new Object[]{fqn});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            this.getParentLogger().log(Level.WARNING, ex, () -> "Could not load translator factory");
        }
        return List.of();
    }

    private <T> List<T> loadServices(Class<T> type) {
        return ServiceLoader.load(type, this.getClass().getClassLoader()).stream().map(ServiceLoader.Provider::get).toList();
    }

    static Supplier<List<Translator>> getSqlTranslatorSupplier(boolean automaticSqlTranslation, Map<String, ?> config, Supplier<List<TranslatorFactory>> sqlTranslatorFactoriesSupplier) throws SQLException {
        if (automaticSqlTranslation) {
            List<TranslatorFactory> factories = sqlTranslatorFactoriesSupplier.get();
            if (factories.isEmpty()) {
                throw Neo4jDriver.noTranslatorsAvailableException();
            }
            return () -> Neo4jDriver.sortedListOfTranslators(config, factories);
        }
        Map<String, ?> localConfig = Map.copyOf(config);
        return () -> Neo4jDriver.sortedListOfTranslators(localConfig, (List)sqlTranslatorFactoriesSupplier.get());
    }

    static SQLException noTranslatorsAvailableException() {
        return new Neo4jException(Neo4jException.withReason("No translators available"));
    }

    private static List<Translator> sortedListOfTranslators(Map<String, ?> config, List<TranslatorFactory> factories) {
        if (factories.size() == 1) {
            Translator t1 = factories.get(0).create(config);
            return t1 != null ? List.of(t1) : List.of();
        }
        return factories.stream().map(factory -> factory.create(config)).filter(Objects::nonNull).sorted(TranslatorComparator.INSTANCE).toList();
    }

    @Override
    public Collection<Bookmark> getCurrentBookmarks(String url, Properties info) throws SQLException {
        BookmarkManager bm = this.bookmarkManagers.get(DriverConfig.of(url, info));
        if (bm == null) {
            return Set.of();
        }
        return bm.getBookmarks(Bookmark::new);
    }

    @Override
    public void addBookmarks(String url, Properties info, Collection<Bookmark> bookmarks) throws SQLException {
        BookmarkManager bm = this.bookmarkManagers.get(DriverConfig.of(url, info));
        if (bm != null) {
            bm.updateBookmarks(Bookmark::value, List.of(), bookmarks);
        }
    }

    @Override
    public void addListener(DriverListener driverListener) {
        this.listeners.add(Objects.requireNonNull(driverListener));
    }

    @Override
    public Neo4jDriver withTracer(Neo4jTracer tracer) {
        this.setTracer(tracer);
        return this;
    }

    @Override
    public synchronized void setTracer(Neo4jTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public synchronized void setAuthenticationSupplier(Supplier<Authentication> authenticationSupplier) {
        this.authenticationSupplier = authenticationSupplier;
    }

    @Override
    public Neo4jDriver withMetadata(Map<String, Object> metadata) {
        if (metadata != null) {
            this.transactionMetadata.putAll(metadata);
        }
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new Neo4jException(Neo4jException.withReason("This object does not implement the given interface"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    static {
        try {
            DriverManager.registerDriver(new Neo4jDriver());
        }
        catch (SQLException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private static final class SpecifyAdditionalPropertiesOrAuthStepImpl
    implements SpecifyAdditionalPropertiesStep,
    SpecifyAdditionalPropertiesOrAuthStep {
        private final BuilderImpl delegate;

        private SpecifyAdditionalPropertiesOrAuthStepImpl(BuilderImpl delegate) {
            this.delegate = delegate;
        }

        @Override
        public SpecifyAuthStep withProperties(Map<String, Object> additionalProperties) {
            return (SpecifyAuthStep)this.delegate.withProperties(additionalProperties);
        }

        @Override
        public SpecifyAdditionalPropertiesStep withAuthenticationSupplier(Supplier<Authentication> authenticationSupplier) {
            return (SpecifyAdditionalPropertiesStep)this.delegate.withAuthenticationSupplier(authenticationSupplier);
        }

        @Override
        public Optional<Connection> fromEnv(Path directory, String filename) throws SQLException {
            return this.delegate.fromEnv(directory, filename);
        }
    }

    private static final class BuilderImpl
    implements SpecifyAdditionalPropertiesStep,
    SpecifyTranslationStep,
    SpecifyAuthStep {
        private boolean forceSqlTranslation;
        private Map<String, Object> additionalProperties;
        private Supplier<Authentication> authenticationSupplier;

        BuilderImpl(boolean forceSqlTranslation, Map<String, Object> additionalProperties, Supplier<Authentication> authenticationSupplier) {
            this.forceSqlTranslation = forceSqlTranslation;
            this.additionalProperties = additionalProperties;
            this.authenticationSupplier = authenticationSupplier;
        }

        @Override
        public Optional<Connection> fromEnv(Path directory, String filename) throws SQLException {
            String authRealm;
            String authScheme;
            String password;
            Dotenv env;
            Object address;
            DotenvBuilder builder = Dotenv.configure().ignoreIfMissing().ignoreIfMalformed();
            if (directory != null) {
                builder = builder.directory(directory.toAbsolutePath().toString());
            }
            if (filename != null && !filename.isBlank()) {
                builder = builder.filename(filename);
            }
            if ((address = (env = builder.load()).get("NEO4J_URI")) != null && !((String)address).toLowerCase(Locale.ROOT).startsWith("jdbc:")) {
                address = "jdbc:" + (String)address;
            }
            if (address == null || !URL_PATTERN.matcher((CharSequence)address).matches()) {
                return Optional.empty();
            }
            Properties properties = new Properties();
            properties.putAll(this.additionalProperties);
            String username = env.get("NEO4J_USERNAME");
            if (username != null) {
                properties.put(Neo4jDriver.PROPERTY_USER, username);
            }
            if ((password = env.get("NEO4J_PASSWORD")) != null) {
                properties.put(Neo4jDriver.PROPERTY_PASSWORD, password);
            }
            if ((authScheme = env.get("NEO4J_AUTH_SCHEME")) != null) {
                properties.put(Neo4jDriver.PROPERTY_AUTH_SCHEME, authScheme);
            }
            if ((authRealm = env.get("NEO4J_AUTH_REALM")) != null) {
                properties.put(Neo4jDriver.PROPERTY_AUTH_REALM, authRealm);
            }
            String sql2cypher = env.get("NEO4J_SQL_TRANSLATION_ENABLED");
            if (this.forceSqlTranslation || Boolean.parseBoolean(sql2cypher)) {
                properties.put(Neo4jDriver.PROPERTY_SQL_TRANSLATION_ENABLED, "true");
            }
            return Optional.of(new Neo4jDriver().connect((String)address, properties, this.authenticationSupplier));
        }

        @Override
        public SpecifyEnvStep withProperties(Map<String, Object> additionalProperties) {
            this.additionalProperties = Objects.requireNonNullElseGet(additionalProperties, Map::of);
            return this;
        }

        @Override
        public SpecifyEnvStep withAuthenticationSupplier(Supplier<Authentication> authenticationSupplier) {
            this.authenticationSupplier = authenticationSupplier;
            return this;
        }

        @Override
        public SpecifyEnvStep withSQLTranslation() {
            this.forceSqlTranslation = true;
            return this;
        }
    }

    private static final class SpecifyTranslationOrAuthStepImpl
    implements SpecifyTranslationStep,
    SpecifyTranslationOrAuthStep {
        private final BuilderImpl delegate;

        private SpecifyTranslationOrAuthStepImpl(BuilderImpl delegate) {
            this.delegate = delegate;
        }

        @Override
        public SpecifyAuthStep withSQLTranslation() {
            return (SpecifyAuthStep)this.delegate.withSQLTranslation();
        }

        @Override
        public SpecifyTranslationStep withAuthenticationSupplier(Supplier<Authentication> authenticationSupplier) {
            return (SpecifyTranslationStep)this.delegate.withAuthenticationSupplier(authenticationSupplier);
        }

        @Override
        public Optional<Connection> fromEnv(Path directory, String filename) throws SQLException {
            return this.delegate.fromEnv(directory, filename);
        }
    }

    private static final class SpecifyAdditionalPropertiesOrTranslationStepImpl
    implements SpecifyAdditionalPropertiesOrTranslationStep {
        private final BuilderImpl delegate;

        private SpecifyAdditionalPropertiesOrTranslationStepImpl(BuilderImpl delegate) {
            this.delegate = delegate;
        }

        @Override
        public SpecifyTranslationStep withProperties(Map<String, Object> additionalProperties) {
            return (SpecifyTranslationStep)this.delegate.withProperties(additionalProperties);
        }

        @Override
        public SpecifyAdditionalPropertiesStep withSQLTranslation() {
            return (SpecifyAdditionalPropertiesStep)this.delegate.withSQLTranslation();
        }

        @Override
        public Optional<Connection> fromEnv(Path directory, String filename) throws SQLException {
            return this.delegate.fromEnv(directory, filename);
        }
    }

    record DriverConfig(String host, String protocol, Integer port, String database, AuthScheme authScheme, String user, String password, String authRealm, String agent, int timeout, boolean enableSQLTranslation, boolean enableTranslationCaching, boolean rewriteBatchedStatements, boolean rewritePlaceholders, boolean useBookmarks, int relationshipSampleSize, SSLProperties sslProperties, Map<String, String> rawConfig) {
        private static final Set<String> DRIVER_SPECIFIC_PROPERTIES = Set.of("host", "port", "database", "authScheme", "user", "password", "authRealm", "agent", "timeout", "enableSQLTranslation", "cacheSQLTranslations", "rewriteBatchedStatements", "rewritePlaceholders", "ssl", "sslMode");

        DriverConfig {
            rawConfig = Collections.unmodifiableMap(new TreeMap<String, String>(rawConfig));
        }

        Map<String, String> misc() {
            HashMap<String, String> misc = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.rawConfig.entrySet()) {
                if (DRIVER_SPECIFIC_PROPERTIES.contains(entry.getKey())) continue;
                misc.put(entry.getKey(), entry.getValue());
            }
            return misc;
        }

        static DriverConfig of(String url, Properties info) throws SQLException {
            String databaseName;
            if (url == null) {
                throw new Neo4jException(Neo4jException.GQLError.$22N06.withTemplatedMessage("url"));
            }
            if (info == null) {
                throw new Neo4jException(Neo4jException.GQLError.$22N06.withTemplatedMessage("info"));
            }
            Matcher matcher = URL_PATTERN.matcher(url);
            if (!matcher.matches()) {
                throw new Neo4jException(Neo4jException.GQLError.$22N11.withTemplatedMessage(url));
            }
            String[] urlParams = Neo4jDriver.splitUrlParams(matcher.group("urlParams"));
            Map<String, String> config = Neo4jDriver.mergeConfig(urlParams, info);
            HashMap<String, String> raw = new HashMap<String, String>(config);
            String protocol = Optional.ofNullable(matcher.group("protocol")).orElse("neo4j");
            String host = matcher.group(Neo4jDriver.PROPERTY_HOST);
            raw.put(Neo4jDriver.PROPERTY_HOST, host);
            String rawPort = matcher.group(Neo4jDriver.PROPERTY_PORT);
            Integer port = null;
            if ("neo4j".equals(protocol)) {
                port = Integer.parseInt(rawPort != null ? rawPort : "7687");
            } else if (rawPort != null) {
                port = Integer.parseInt(rawPort);
            }
            if (rawPort != null) {
                raw.put(Neo4jDriver.PROPERTY_PORT, matcher.group(Neo4jDriver.PROPERTY_PORT));
            }
            if ((databaseName = matcher.group(Neo4jDriver.PROPERTY_DATABASE)) == null) {
                databaseName = config.getOrDefault(Neo4jDriver.PROPERTY_DATABASE, "neo4j");
            } else {
                raw.put(Neo4jDriver.PROPERTY_DATABASE, databaseName);
            }
            SSLProperties sslProperties = Neo4jDriver.parseSSLProperties(config, matcher.group("transport"));
            raw.put(Neo4jDriver.PROPERTY_SSL, String.valueOf(sslProperties.ssl));
            raw.put(Neo4jDriver.PROPERTY_SSL_MODE, sslProperties.sslMode.getName());
            AuthScheme authScheme = DriverConfig.authScheme(config.get(Neo4jDriver.PROPERTY_AUTH_SCHEME));
            String user = String.valueOf(config.getOrDefault(Neo4jDriver.PROPERTY_USER, "neo4j"));
            String password = String.valueOf(config.getOrDefault(Neo4jDriver.PROPERTY_PASSWORD, ""));
            String authRealm = config.getOrDefault(Neo4jDriver.PROPERTY_AUTH_REALM, "");
            String userAgent = String.valueOf(config.getOrDefault(Neo4jDriver.PROPERTY_USER_AGENT, Neo4jDriver.getDefaultUserAgent()));
            int connectionTimeoutMillis = Integer.parseInt(config.getOrDefault(Neo4jDriver.PROPERTY_TIMEOUT, "1000"));
            boolean automaticSqlTranslation = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_SQL_TRANSLATION_ENABLED, "false"));
            boolean enableTranslationCaching = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_SQL_TRANSLATION_CACHING_ENABLED, "false"));
            boolean rewriteBatchedStatements = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_REWRITE_BATCHED_STATEMENTS, "true"));
            boolean rewritePlaceholders = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_REWRITE_PLACEHOLDERS, Boolean.toString(!automaticSqlTranslation)));
            boolean useBookmarks = Boolean.parseBoolean(config.getOrDefault(Neo4jDriver.PROPERTY_USE_BOOKMARKS, "true"));
            int relationshipSampleSize = Integer.parseInt(config.getOrDefault(Neo4jDriver.PROPERTY_RELATIONSHIP_SAMPLE_SIZE, "1000"));
            if (relationshipSampleSize < -1) {
                throw new Neo4jException(Neo4jException.GQLError.$22N02.withMessage("Sample size for relationships must be greater than or equal -1"));
            }
            return new DriverConfig(host, protocol, port, databaseName, authScheme, user, password, authRealm, userAgent, connectionTimeoutMillis, automaticSqlTranslation, enableTranslationCaching, rewriteBatchedStatements, rewritePlaceholders, useBookmarks, relationshipSampleSize, sslProperties, raw);
        }

        private static AuthScheme authScheme(String scheme) throws IllegalArgumentException {
            if (scheme == null || scheme.isBlank()) {
                return AuthScheme.BASIC;
            }
            try {
                return AuthScheme.valueOf(scheme.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ignored) {
                throw new IllegalArgumentException("%s is not a valid option for authScheme".formatted(scheme));
            }
        }

        String formattedPort() {
            return this.port() != null ? ":" + this.port() : "";
        }

        URI toUrl() {
            SSLProperties sslProperties = this.sslProperties();
            StringBuilder result = new StringBuilder("jdbc:neo4j%s%s://%s%s/%s?".formatted(sslProperties.protocolSuffix(), "neo4j".equals(this.protocol()) ? "" : ":" + this.protocol(), this.host(), this.formattedPort(), this.database()));
            DriverConfig.append(result, Neo4jDriver.PROPERTY_SQL_TRANSLATION_ENABLED, this.enableSQLTranslation()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_SQL_TRANSLATION_CACHING_ENABLED, this.enableTranslationCaching()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_REWRITE_BATCHED_STATEMENTS, this.rewriteBatchedStatements()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_REWRITE_PLACEHOLDERS, this.rewriteBatchedStatements()).append("&");
            DriverConfig.append(result, Neo4jDriver.PROPERTY_USE_BOOKMARKS, this.useBookmarks()).append("&");
            return URI.create(result.substring(0, result.length() - 1));
        }

        static StringBuilder append(StringBuilder result, String name, Object value) {
            result.append(URLEncoder.encode(name, StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(String.valueOf(value), StandardCharsets.UTF_8));
            return result;
        }
    }

    record SSLProperties(SSLMode sslMode, boolean ssl) {
        String protocolSuffix() {
            if (!this.ssl) {
                return "";
            }
            return this.sslMode == SSLMode.VERIFY_FULL ? "+s" : "+ssc";
        }
    }

    static enum AuthScheme {
        NONE("none"),
        BASIC("basic"),
        BEARER("bearer"),
        KERBEROS("kerberos");

        private final String name;

        private AuthScheme(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static enum SSLMode {
        DISABLE("disable"),
        REQUIRE("require"),
        VERIFY_FULL("verify-full");

        private final String name;

        private SSLMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SpecifyAuthStep
    extends SpecifyEnvStep {
        public SpecifyEnvStep withAuthenticationSupplier(Supplier<Authentication> var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SpecifyAdditionalPropertiesStep
    extends SpecifyEnvStep {
        public SpecifyEnvStep withProperties(Map<String, Object> var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SpecifyTranslationStep
    extends SpecifyEnvStep {
        public SpecifyEnvStep withSQLTranslation();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SpecifyTranslationOrAuthStep
    extends SpecifyEnvStep {
        public SpecifyAuthStep withSQLTranslation();

        public SpecifyTranslationStep withAuthenticationSupplier(Supplier<Authentication> var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SpecifyAdditionalPropertiesOrAuthStep
    extends SpecifyEnvStep {
        public SpecifyAuthStep withProperties(Map<String, Object> var1);

        public SpecifyAdditionalPropertiesStep withAuthenticationSupplier(Supplier<Authentication> var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface SpecifyAdditionalPropertiesOrTranslationStep
    extends SpecifyEnvStep {
        public SpecifyTranslationStep withProperties(Map<String, Object> var1);

        public SpecifyAdditionalPropertiesStep withSQLTranslation();
    }

    public static interface SpecifyEnvStep {
        default public Optional<Connection> fromEnv() throws SQLException {
            return this.fromEnv(null, null);
        }

        default public Optional<Connection> fromEnv(Path directory) throws SQLException {
            return this.fromEnv(directory, null);
        }

        default public Optional<Connection> fromEnv(String filename) throws SQLException {
            return this.fromEnv(null, filename);
        }

        public Optional<Connection> fromEnv(Path var1, String var2) throws SQLException;
    }
}

