/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.Neo4jTransaction;
import org.neo4j.jdbc.ResultSetImpl;
import org.neo4j.jdbc.StatementImpl;
import org.neo4j.jdbc.ThrowingTransactionImpl;

final class LocalStatementImpl
extends StatementImpl {
    private final Connection connection;
    private final Neo4jTransaction.RunResponse runResponse;
    private final Neo4jTransaction.PullResponse pullResponse;
    private boolean closeOnCompletion;
    private boolean closed;
    private final AtomicBoolean resultSetAcquired = new AtomicBoolean(false);

    LocalStatementImpl(Connection connection, Neo4jTransaction.RunResponse runResponse, Neo4jTransaction.PullResponse pullResponse) {
        this.connection = connection;
        this.runResponse = runResponse;
        this.pullResponse = pullResponse;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (!this.resultSetAcquired.compareAndSet(false, true)) {
            throw new Neo4jException(Neo4jException.withReason("Result set has already been acquired"));
        }
        return new ResultSetImpl(this, new ThrowingTransactionImpl(), this.runResponse, this.pullResponse, -1, -1, -1);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.assertIsOpen();
        return -1;
    }

    @Override
    public boolean getMoreResults() {
        return !this.resultSetAcquired.get();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchSize() {
        return -1;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.assertIsOpen();
        return 2;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    @Override
    protected void assertIsOpen() throws SQLException {
        if (this.closed) {
            throw new Neo4jException(Neo4jException.withReason("The statement set is closed"));
        }
    }
}

