/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import org.neo4j.jdbc.ThrowingSupplier;

final class Lazy<T> {
    private final ThrowingSupplier<T> supplier;
    private volatile T resolved;

    static <T> Lazy<T> of(ThrowingSupplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    private Lazy(ThrowingSupplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T resolve() {
        T result = this.resolved;
        if (result == null) {
            Lazy lazy = this;
            synchronized (lazy) {
                result = this.resolved;
                if (result == null) {
                    try {
                        this.resolved = this.supplier.get();
                    }
                    catch (Exception ex) {
                        if (ex instanceof RuntimeException) {
                            RuntimeException rt = (RuntimeException)ex;
                            throw rt;
                        }
                        throw new RuntimeException(ex);
                    }
                    result = this.resolved;
                }
            }
        }
        return result;
    }

    <E extends Throwable> T resolveThrowing(Class<E> type) throws E {
        try {
            return this.resolve();
        }
        catch (Exception ex) {
            if (type.isAssignableFrom(ex.getCause().getClass())) {
                throw (Throwable)type.cast(ex.getCause());
            }
            throw ex;
        }
    }

    boolean isResolved() {
        return this.resolved != null;
    }

    void forget() {
        this.resolved = null;
    }
}

