/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.jdbc.JSONMapper;

enum JSONMappers {
    INSTANCE;

    private static final Logger LOGGER;
    private static final Map<String, String> KNOWN_MAPPERS;
    private final Map<String, Optional<JSONMapper<?>>> loadedMappers = new ConcurrentHashMap();

    public Optional<JSONMapper<?>> getMapper(String typeName) {
        return this.loadedMappers.computeIfAbsent(typeName, JSONMappers::loadMapper);
    }

    private static Optional<JSONMapper<?>> loadMapper(String typeName) {
        String mapperClass = KNOWN_MAPPERS.get(typeName);
        if (mapperClass == null) {
            try {
                Class<?> type = Class.forName(typeName);
                for (String mappedTypedName : KNOWN_MAPPERS.keySet()) {
                    Class<?> mappedType = Class.forName(mappedTypedName, false, JSONMappers.class.getClassLoader());
                    if (!mappedType.isAssignableFrom(type)) continue;
                    mapperClass = KNOWN_MAPPERS.get(mappedTypedName);
                }
            }
            catch (Exception type) {
                // empty catch block
            }
        }
        if (mapperClass == null) {
            return Optional.empty();
        }
        try {
            String name = JSONMappers.class.getPackageName() + "." + mapperClass;
            LOGGER.log(Level.FINE, "Trying to load mapper {0}", name);
            Class<?> mapperType = Class.forName(name, true, JSONMappers.class.getClassLoader());
            return Optional.of((JSONMapper)mapperType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.log(Level.WARNING, "Could not load a mapper for %s".formatted(typeName));
            return Optional.empty();
        }
    }

    static {
        LOGGER = Logger.getLogger(JSONMappers.class.getName());
        KNOWN_MAPPERS = Map.of("com.fasterxml.jackson.databind.JsonNode", "JacksonJSONMapperImpl");
    }
}

